<?php $__env->startSection('content'); ?>

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success" role="alert">
                <?php echo e($message); ?>

            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">Tarif des Produits</div>
            <div class="card-body">
                <div id="toolbar">
                    <a href="<?php echo e(route('tarifs.create')); ?>" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Renseigner le Prix d'un Produit</a>
                </div>
                <table
                    id="table"
                    data-toolbar="#toolbar"
                    data-toggle="table"
                    data-show-toggle="false"
                    data-show-fullscreen="true"
                    data-search="true"
                    data-show-columns="true"
                    data-pagination="true"
                    data-show-export="true"
                    data-export-data-type="all"
                    data-export-types="['csv', 'excel' , 'pdf']"
                    data-cookie="true"
                    data-cookie-id-table="tarifsIndex"
                    data-show-footer="false"
                    class="table table-striped table-bordered"
                    >
                    <thead>
                      <tr>
                        <th scope="col" data-sortable="true">Ref</th>
                        <th scope="col">Ref2</th>
                        <th scope="col" data-sortable="true">Site</th>
                        <th scope="col" data-sortable="true">Famille</th>
                        <th scope="col" data-sortable="true">Type</th>
                        <th scope="col" data-sortable="true">Essence</th>
                        <th scope="col" data-sortable="true">Qualité</th>
                        <th scope="col">Epaisseur</th>
                        <th scope="col">Largeur</th>
                        <th scope="col">Longueur</th>
                        <th scope="col">Humidité</th>
                        <th scope="col" data-sortable="true">Origine</th>
                        <th scope="col">Prix de revient</th>
                        <th scope="col">Prix Négociant</th>
                        <th scope="col">Date de Début</th>
                        <th scope="col">Date de Fin</th>
                        <th scope="col" data-force-hide="true">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php $produit = $data->produit()->first(); ?>
                        <tr>
                            <td><?php echo e($produit->referenceA); ?></td>
                            <td><?php echo e($produit->referenceB); ?></td>
                            <?php if(null == $produit->alternatif || '' == $produit->alternatif): ?>
                            <td><?php echo e($produit->site); ?></td>
                            <td><?php echo e($produit->famille); ?></td>
                            <td><?php echo e($produit->type); ?></td>
                            <td><?php if( $produit->essence == '--N/A--'): ?> &nbsp; <?php else: ?> <?php echo e($produit->essence); ?><?php endif; ?></td>
                            <td><?php echo e($produit->qualite); ?></td>
                            <td><?php if($produit->epaisseur>0): ?> <?php echo e($produit->epaisseur); ?> <?php else: ?> &nbsp; <?php endif; ?></td>
                            <td><?php if($produit->largeur>0): ?> <?php echo e($produit->largeur); ?> <?php else: ?> &nbsp; <?php endif; ?></td>
                            <td><?php if($produit->longueur>0): ?> <?php echo e($produit->longueur); ?> <?php else: ?> &nbsp; <?php endif; ?></td>
                            <td><?php echo e($produit->humiditeLabel()); ?></td>
                            <?php else: ?>
                            <td colspan="9"><?php echo e($produit->alternatif); ?></td>
                            <?php endif; ?>
                            <td><?php echo e($produit->origine); ?></td>
                            <td style="text-align:right"><?php echo e(round($data->prix_revient, 2)); ?>&nbsp;&euro;</td>
                            <td style="text-align:right"><?php if($data->prix_negociant>0): ?><?php echo e(round($data->prix_negociant, 2)); ?>&nbsp;&euro;<?php else: ?>&nbsp;<?php endif; ?></td>
                            <td><?php echo e($data->date_debut->format('d-m-Y')); ?></td>
                            <td><?php echo e($data->date_fin->format('d-m-Y')); ?></td>
                            <td>
                                <form action="<?php echo e(route('tarifs.destroy', $data->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>

                                    <?php if(1==2): ?>
                                    <a href="<?php echo e(route('tarifs.show', $data->id)); ?>" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a>
                                    <a href="<?php echo e(route('tarifs.edit', $data->id)); ?>" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif</a>
                                    <?php endif; ?>
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer cette période de Tarif ?');"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="17">
                                <span class="text-danger">
                                    <strong>Aucun inventaire!</strong>
                                </span>
                            </td>
                        <?php endif; ?>
                    </tbody>
                  </table>

            </div>
        </div>
    </div>    
</div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tarifs.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/IntranetFontenoyBois/resources/views/tarifs/index.blade.php ENDPATH**/ ?>