<?php $__env->startSection('content'); ?>

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                    Production du
                    <?php if(!$gestions->isEmpty()): ?>
                        <?php
                            $date = strtotime($gestions[0]->date_mouvement);
                            setlocale(LC_TIME, 'fr_FR.utf8', 'fr_FR', 'fr');
                            echo strftime('%A %e %B %Y', $date);
                        ?>
                    <?php endif; ?>
                </div>
                <div class="float-end">
                    <a href="<?php echo e(route('gestions.index')); ?>" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <h2>Liste des productions :</h2>
                <div class="card-body">
                    <?php if($gestions->isEmpty()): ?>
                        <p>Aucune gestion enregistrée pour le moment.</p>
                    <?php else: ?>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">Produit</th>
                                    <th scope="col">Quantité</th>
                                    <th scope="col"></th> <!-- Colonne vide pour le bouton -->
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $gestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gestion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($gestion->produit->getDescriptifFullOrAlter()); ?></td>
                                        <td class="text-center"><?php echo e($gestion->quantite * 1); ?> <?php echo e($gestion->unite); ?></td>
                                        <td>
                                        <form action="<?php echo e(route('gestions.destroy', $gestion->id)); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>

                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer cet Inventaire ?');"><i class="bi bi-trash"></i> Suppr</button>
                                </form>
                                        
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
                <form action="<?php echo e(route('gestions.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>

                    <script type="text/javascript">
                        $(document).ready(function() {
                            $('.select2').select2();
                        })
                    </script>

                    <div class="mb-3 row">
                    <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                    <div class="col-md-6">
                        <select class="form-control <?php $__errorArgs = ['produit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="produit_id" id="produit_id">
                            <?php $__currentLoopData = $produits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($produit->id); ?>" <?php if(old('produit_id') == $produit->id): ?> selected="selected" <?php endif; ?>>
                                    <?php echo e($produit->referenceA . ' - ' . $produit->getDescriptifFullOrAlter()); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('produit_id')): ?>
                            <span class="text-danger"><?php echo e($errors->first('produit_id')); ?></span>
                        <?php endif; ?>
                    </div>

                    </div>



                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité produite</label>
                        <div class="col-md-6">
                            <input type="number" class="form-control <?php $__errorArgs = ['quantite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="quantite" name="quantite" value="<?php echo e(old('quantite')); ?>">
                            <?php if($errors->has('quantite')): ?>
                                <span class="text-danger"><?php echo e($errors->first('quantite')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['unite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="unite">
                                <option value="m2" <?php if(old('unite') == 'm2'): ?> selected="selected" <?php endif; ?>>m<sup>2</sup></option>
                                <option value="m3" <?php if(old('unite') == 'm3'): ?> selected="selected" <?php endif; ?>>m3</option>
                                <option value="Stère" <?php if(old('unite') == 'Stère'): ?> selected="selected" <?php endif; ?>>Stère</option>
                                <option value="Pile" <?php if(old('unite') == 'Pile'): ?> selected="selected" <?php endif; ?>>Pile</option>
                                <option value="ml" <?php if(old('unite') == 'ml'): ?> selected="selected" <?php endif; ?>>ml</option>
                                <option value="Pièce" <?php if(old('unite') == 'Pièce'): ?> selected="selected" <?php endif; ?>>Pièce</option>
                                <option value="Kilo" <?php if(old('unite') == 'Kilo'): ?> selected="selected" <?php endif; ?>>Kilo</option>
                                <option value="Rouleau" <?php if(old('unite') == 'rouleau'): ?> selected="selected" <?php endif; ?>>Rouleau</option>
                                <option value="Palette" <?php if(old('unite') == 'Palette' || !old('unite')): ?> selected="selected" <?php endif; ?>>Palette</option>
                            </select>
                            <?php if($errors->has('unite')): ?>
                                <span class="text-danger"><?php echo e($errors->first('unite')); ?></span>
                            <?php endif; ?>
                        </div>
                </div>


                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Ajouter le Produit">
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.getElementById('btnProductionJour').addEventListener('click', function() {
        fetch('/liste-elements') // Route appropriée pour récupérer la liste
            .then(response => response.json())
            .then(data => {
                var listeElements = document.getElementById('listeElements');
                listeElements.innerHTML = ''; // Efface la liste actuelle
                data.forEach(element => {
                    var li = document.createElement('li');
                    li.textContent = element;
                    listeElements.appendChild(li);
                });
            })
            .catch(error => console.error('Erreur lors de la récupération de la liste :', error));
    });

    function confirmDelete(gestionId) {
        console.log('Confirm delete function called with ID:', gestionId);

        var isConfirmed = confirm('Êtes-vous sûr de vouloir supprimer ce produit en stock ?');

        if (isConfirmed) {
            // Supprimer le produit en stock
            document.getElementById('deleteForm_' + gestionId).submit();
        }
    }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('gestions.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/IntranetFontenoyBois/resources/views/gestions/create.blade.php ENDPATH**/ ?>