@extends('produits.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif
        <div class="card">
            <div class="card-header">Liste des Produits</div>
            <div class="card-body">
                <a href="{{ route('produits.create') }}" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter un Produit</a>
                <table 
  data-toggle="table"
  data-search="true"
  data-show-columns="true"
  data-pagination="true"
  data-sortable="true"
  class="table table-striped table-bordered"
  >
                    <thead>
                      <tr>
                        <th scope="col">S#</th>
                        <th scope="col">@sortablelink('referenceA', 'Ref')</th>
                        <th scope="col">Ref2</th>
                        <th scope="col">@sortablelink('site', 'Site')</th>
                        <th scope="col">@sortablelink('famille', 'Famille')</th>
                        <th scope="col">@sortablelink('type', 'Type')</th>
                        <th scope="col">@sortablelink('essence', 'Essence')</th>
                        <th scope="col">@sortablelink('qualite', 'Qualité')</th>
                        <th scope="col">Epaisseur</th>
                        <th scope="col">Largeur</th>
                        <th scope="col">Longueur</th>
                        <th scope="col">Humidité</th>
                        <th scope="col">@sortablelink('origine', 'Origine')</th>
                        <th scope="col">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                        @forelse ($produits as $produit)
                        <tr>
                            <th scope="row">{{ $loop->iteration }}</th>
                            <td>{{ $produit->referenceA }}</td>
                            @if(null == $produit->alternatif || '' == $produit->alternatif)
                            <td>{{ $produit->referenceB }}</td>
                            <td>{{ $produit->site }}</td>
                            <td>{{ $produit->famille }}</td>
                            <td>{{ $produit->type }}</td>
                            <td>{{ $produit->essence }}</td>
                            <td>{{ $produit->qualite }}</td>
                            <td>@if($produit->epaisseur>0) {{ $produit->epaisseur }} @else &nbsp; @endif</td>
                            <td>@if($produit->largeur>0) {{ $produit->largeur }} @else &nbsp; @endif</td>
                            <td>@if($produit->longueur>0) {{ $produit->longueur }} @else &nbsp; @endif</td>
                            <td>{{ $produit->humiditeLabel() }}</td>
                            <td>{{ $produit->origine }}</td>
                            @else
                            <td colspan="11">{{ $produit->alternatif }}</td>
                            @endif
                            <td>
                                <form action="{{ route('produits.destroy', $produit->id) }}" method="post">
                                    @csrf
                                    @method('DELETE')

                                    <a href="{{ route('produits.show', $produit->id) }}" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a>

                                    <a href="{{ route('produits.edit', $produit->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif</a>

                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer ce Produit ?');"><i class="bi bi-trash"></i> Suppr</button>
                                </form>
                            </td>
                        </tr>
                        @empty
                            <td colspan="13">
                                <span class="text-danger">
                                    <strong>Aucun produit!</strong>
                                </span>
                            </td>
                        @endforelse
                    </tbody>
                  </table>

                    produits->withQueryString()->links() 

            </div>
        </div>
    </div>    
</div>
    
@endsection
