@extends('inventaires.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                    Modifier l'Inventaire
                </div>
                <div class="float-end">
                    <a href="{{ route('inventaires.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('inventaires.update', $inventaire->id) }}" method="post">
                    @csrf
                    @method("PUT")

                    <div class="mb-3 row">
                        <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                        <div class="col-md-6">{{ $inventaire->produit()->first()->referenceA.' - ' }}@if(null != $inventaire->produit()->first()->alternatif || '' != $inventaire->produit()->first()->alternatif) {{ $inventaire->produit()->first()->alternatif }}@else {{ $inventaire->produit()->first()->getDescriptifFull() }} @endif
                            <input type="hidden" name="produit_id" value="{{ $inventaire->produit_id }}" />
                        </div>
                    </div>

                    <script type="text/javascript" >
                            $(document).ready(function() {
                                $('.select2').select2();
                            })
                    </script>

                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité en inventaire</label>
                        <div class="col-md-6">
                          <input type="number" class="form-control @error('quantite') is-invalid @enderror" id="quantite" name="quantite" value="{{ $inventaire->quantite }}">
                            @if ($errors->has('quantite'))
                                <span class="text-danger">{{ $errors->first('quantite') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité</label>
                        <div class="col-md-6">
                            <select class="form-control @error('unite') is-invalid @enderror" name="unite">
                                @foreach(App\Models\Produit::$unitesDeVentes as $code => $codeDetail)
                                <option value="{{$code}}" @if ($inventaire->unite == $code) selected="selected" @endif><?=$codeDetail['html']?></option>  
                                @endforeach
                            </select>
                            @if ($errors->has('unite'))
                                <span class="text-danger">{{ $errors->first('unite') }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="mb-3 row">
                        <label for="localisation" class="col-md-4 col-form-label text-md-end text-start">Localisation</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('quantite') is-invalid @enderror" id="localisation" name="localisation" value="{{ $inventaire->localisation }}">
                            @if ($errors->has('localisation'))
                                <span class="text-danger">{{ $errors->first('localisation') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Mettre a jour l'Inventaire">
                    </div>
                    
                </form>
            </div>
        </div>
    </div>    
</div>
    
@endsection
