@extends('gestions.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif

        @for ($i = 0; $i <= 30; $i++)
            @php
                $currentDate = now()->subDays($i)->toDateString();
            
            @endphp
            @if( (strftime('%A', strtotime($currentDate)) != 'samedi') && (strftime('%A', strtotime($currentDate)) != 'dimanche'))
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
			<div class="text-center">
                        Production du {{ strftime('%A', strtotime($currentDate)) }} {{ strftime('%d %B %Y', strtotime($currentDate)) }}
                        </div>

                        <div class="text-end">
                        <a href="{{ route('gestions.create', ['date' => $currentDate]) }}" class="btn btn-success btn-sm">Modifier la production</a>

                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">Produit</th>
                                <th scope="col">Quantité</th>
                                <th scope="col">Unité</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($stock as $produitStock)
                
                           
                            @if($produitStock->date_mouvement->format('Y-m-d')==$currentDate)   
                            <tr>
                                    <td>{{ $produitStock->produit->getDescriptifFullOrAlter() }}</td>
                                    <td>{{ $produitStock->quantite *1}}</td>
                                    <td>{{ $produitStock->unite }}</td>
                                    <td></td>
                                </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <br>
            @endif
        @endfor
    </div>
</div>

@endsection
