@extends('gestions.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                    Production du
                    @if (!$gestions->isEmpty())
                        <?php
                            $date = strtotime($gestions[0]->date_mouvement);
                            setlocale(LC_TIME, 'fr_FR.utf8', 'fr_FR', 'fr');
                            echo strftime('%A %e %B %Y', $date);
                        ?>
                    @endif
                </div>
                <div class="float-end">
                    <a href="{{ route('gestions.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <h2>Liste des productions :</h2>
                <div class="card-body">
                    @if ($gestions->isEmpty())
                        <p>Aucune gestion enregistrée pour le moment.</p>
                    @else
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">Produit</th>
                                    <th scope="col">Quantité</th>
                                    <th scope="col"></th> <!-- Colonne vide pour le bouton -->
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($gestions as $gestion)
                                    <tr>
                                        <td>{{ $gestion->produit->getDescriptifFullOrAlter() }}</td>
                                        <td class="text-center">{{ $gestion->quantite * 1 }} {{ $gestion->unite }}</td>
                                        <td>
                                        <form action="{{ route('gestions.destroy', $gestion->id) }}" method="post">
                                            @csrf
                                            @method('DELETE')

                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer cet Inventaire ?');"><i class="bi bi-trash"></i> Suppr</button>
                                </form>
                                        
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @endif
                </div>
                <form action="{{ route('gestions.store') }}" method="post">
                    @csrf

                    <script type="text/javascript">
                        $(document).ready(function() {
                            $('.select2').select2();
                        })
                    </script>

                    <div class="mb-3 row">
                    <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                    <div class="col-md-6">
                        <select class="form-control @error('produit_id') is-invalid @enderror select2" name="produit_id" id="produit_id">
                            @foreach ($produits as $produit)
                                <option value="{{ $produit->id }}" @if (old('produit_id') == $produit->id) selected="selected" @endif>
                                    {{ $produit->referenceA . ' - ' . $produit->getDescriptifFullOrAlter() }}
                                </option>
                            @endforeach
                        </select>
                        @if ($errors->has('produit_id'))
                            <span class="text-danger">{{ $errors->first('produit_id') }}</span>
                        @endif
                    </div>

                    </div>



                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité produite</label>
                        <div class="col-md-6">
                            <input type="number" class="form-control @error('quantite') is-invalid @enderror" id="quantite" name="quantite" value="{{ old('quantite') }}">
                            @if ($errors->has('quantite'))
                                <span class="text-danger">{{ $errors->first('quantite') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité</label>
                        <div class="col-md-6">
                            <select class="form-control @error('unite') is-invalid @enderror" name="unite">
                                <option value="m2" @if (old('unite') == 'm2') selected="selected" @endif>m<sup>2</sup></option>
                                <option value="m3" @if (old('unite') == 'm3') selected="selected" @endif>m3</option>
                                <option value="Stère" @if (old('unite') == 'Stère') selected="selected" @endif>Stère</option>
                                <option value="Pile" @if (old('unite') == 'Pile') selected="selected" @endif>Pile</option>
                                <option value="ml" @if (old('unite') == 'ml') selected="selected" @endif>ml</option>
                                <option value="Pièce" @if (old('unite') == 'Pièce') selected="selected" @endif>Pièce</option>
                                <option value="Kilo" @if (old('unite') == 'Kilo') selected="selected" @endif>Kilo</option>
                                <option value="Rouleau" @if (old('unite') == 'rouleau') selected="selected" @endif>Rouleau</option>
                                <option value="Palette" @if (old('unite') == 'Palette' || !old('unite')) selected="selected" @endif>Palette</option>
                            </select>
                            @if ($errors->has('unite'))
                                <span class="text-danger">{{ $errors->first('unite') }}</span>
                            @endif
                        </div>
                </div>


                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Ajouter le Produit">
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    document.getElementById('btnProductionJour').addEventListener('click', function() {
        fetch('/liste-elements') // Route appropriée pour récupérer la liste
            .then(response => response.json())
            .then(data => {
                var listeElements = document.getElementById('listeElements');
                listeElements.innerHTML = ''; // Efface la liste actuelle
                data.forEach(element => {
                    var li = document.createElement('li');
                    li.textContent = element;
                    listeElements.appendChild(li);
                });
            })
            .catch(error => console.error('Erreur lors de la récupération de la liste :', error));
    });

    function confirmDelete(gestionId) {
        console.log('Confirm delete function called with ID:', gestionId);

        var isConfirmed = confirm('Êtes-vous sûr de vouloir supprimer ce produit en stock ?');

        if (isConfirmed) {
            // Supprimer le produit en stock
            document.getElementById('deleteForm_' + gestionId).submit();
        }
    }
</script>

@endsection