@extends('clients.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif

        <div class="card">
            <div class="card-header">Liste des Clients</div>
            <div class="card-body">
                <a href="{{ route('clients.create') }}" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter un Client au fichier</a>
                <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th scope="col">S#</th>
                        <th scope="col">Code</th>
                        <th scope="col">@sortablelink('nom', 'Nom')</th>
                        <th scope="col">@sortablelink('email', 'Email')</th>
                        <th scope="col">Raison sociale</th>
                        <th scope="col">Adresse</th>
                        <th scope="col">Cp</th>
                        <th scope="col">Ville</th>
                        <th scope="col">Siret</th>
                        <th scope="col">Tel</th>
                        <th scope="col">Contact</th>
                        <th scope="col">Mobile</th>
                        <th scope="col">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                        @forelse ($datas as $data)
                        <tr>
                            <td scope="row">{{ $loop->iteration }}</td>
                            <td>{{ $data->code_client }}</td>
                            <td>{{ $data->nom }}</td>
                            <td>{{ $data->email }}</td>
                            <td>{{ $data->raison_sociale }}</td>
                            <td>{{ $data->adresse }}</td>
                            <td>{{ $data->cp }}</td>
                            <td>{{ $data->ville }}</td>
                            <td>{{ $data->siret }}</td>
                            <td>{{ $data->telephone }}</td>
                            <td>{{ $data->contact }}</td>
                            <td>{{ $data->mobile }}</td>
                            <td>
                                <form action="{{ route('clients.destroy', $data->id) }}" method="post">
                                    @csrf
                                    @method('DELETE')

               
                                    <a href="{{ route('clients.edit', $data->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif</a>
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer ce Client ?');"><i class="bi bi-trash"></i> Suppr</button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <td colspan="7">
                            <span class="text-danger">
                                <strong>Aucun client!</strong>
                            </span>
                        </td>
                        @endforelse
                    </tbody>
                </table>

                {{  $datas->withQueryString()->links() }}
            </div>
        </div>
    </div>    
</div>
    
@endsection
