<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // \App\Models\User::factory(10)->create();
        
        // Création des Utilisateurs de Bases
         $this->call([
            UsersSeeder::class,
        ]);

         \App\Models\Produit::create([
            'referenceA' => 'BCHATAVIV27',
            'referenceB' => null,
            'site' => 'Briolance',
            'famille' => 'Avivé',
            'type' => null,
            'essence' => 'Châtaignier',
            'qualite' => null,
            'epaisseur' => 27,
            'largeur' => 0,
            'longueur' => 2000,
            'humidite' => 100,
            'origine' => 'Production'
        ]);

        \App\Models\Produit::create([
            'referenceA' => 'TRAV2600',
            'referenceB' => null,
            'site' => 'Loubejac',
            'famille' => 'Traverse',
            'type' => 'Non Traité',
            'essence' => 'Chêne',
            'qualite' => 'Paysagère',
            'epaisseur' => 100,
            'largeur' => 200,
            'longueur' => 2600,
            'humidite' => 12,
            'origine' => 'Negoce'
        ]);

        \App\Models\Produit::create([
            'referenceA' => 'ACCPL11RUS',
            'referenceB' => null,
            'site' => 'Loubejac',
            'famille' => 'Plinthe',
            'type' => 'Poncé',
            'essence' => 'Châtaignier',
            'qualite' => 'Rustique',
            'epaisseur' => 15,
            'largeur' => 110,
            'longueur' => 0,
            'humidite' => 12,
            'origine' => 'Production',
            'analytiqueA' => 'ACC'
        ]);

        \App\Models\Produit::create([
            'referenceA' => 'ACCPL7RUS',
            'referenceB' => null,
            'site' => 'Loubejac',
            'famille' => 'Plinthe',
            'type' => 'Poncé',
            'essence' => 'Châtaignier',
            'qualite' => 'Rustique',
            'epaisseur' => 15,
            'largeur' => 70,
            'longueur' => 2000,
            'humidite' => 12,
            'origine' => 'Production',
            'analytiqueA' => 'ACC'
        ]);
        \App\Models\Essence::create([
            'titre' => 'Châtaignier'
        ]);
        \App\Models\Essence::create([
            'titre' => 'Chêne'
        ]);
        \App\Models\Essence::create([
            'titre' => 'Peuplier'
        ]);
        \App\Models\Essence::create([
            'titre' => 'Douglas'
        ]);
        \App\Models\Essence::create([
            'titre' => 'Pin'
        ]);
        \App\Models\Essence::create([
            'titre' => 'Robinier'
        ]);
	\App\Models\Essence::create([
            'titre' => 'Pin Maritime'
        ]);



        $this->call([
            ProduitSeeder::class,
        ]);

        $this->call([
            ColisSeeder::class,
        ]);

        \App\Models\Inventaire::create([
            'produit_id' => 4,
            'quantite' => 230,
            'unite' => 'm2'
        ]);
        \App\Models\Inventaire::create([
            'produit_id' => 4,
            'quantite' => 200,
            'unite' => 'm2',
            'date' => '2021-12-31'
        ]);
        \App\Models\Inventaire::create([
            'produit_id' => 1,
            'quantite' => 30,
            'unite' => 'm3'
        ]);
        \App\Models\Inventaire::create([
            'produit_id' => 24,
            'quantite' => 15,
            'unite' => 'rouleau'
        ]);

        \App\Models\Client::create([
            'nom' => 'ECOBIO'
        ]);
        \App\Models\Client::create([
            'nom' => 'PLANETE'
        ]);

        \App\Models\Commande::create([
            'client_id' => 1,
            'produit_id' => 1,
            'quantite' => 15,
            'unite' => 'Pile'
        ]);
        \App\Models\Commande::create([
            'client_id' => 2,
            'produit_id' => 5,
            'quantite' => 5,
            'unite' => 'Rouleau'
        ]);
        \App\Models\Stock::create([
            'produit_id' => 4,
            'quantite' => 43.2,
            'unite' => 'm2'
        ]);
        \App\Models\Stock::create([
            'produit_id' => 4,
            'quantite' => -43.2,
            'unite' => 'm2'
        ]);
        \App\Models\Stock::create([
            'produit_id' => 4,
            'quantite' => -10.2,
            'unite' => 'm2'
        ]);
        \App\Models\Stock::create([
            'produit_id' => 5,
            'quantite' => 5,
            'unite' => 'Rouleau'
        ]);


    }
}
