<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create('commandes', function (Blueprint $table) {
            $table->id();
            $table->date('date_commande')->default(DB::raw('NOW()'));
            $table->foreignId('client_id')->constrained('clients');
            $table->foreignId('produit_id')->constrained('produits');
            $table->integer('quantite');
            $table->string('unite');
            $table->date('date_annonce')->nullable();
            $table->text('observations')->nullable();
            $table->enum('statut', ['encours', 'expedie', 'cloturee', 'annule'])->default('encours');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists('commandes');
    }
};
