<?php

namespace App\Models;

use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Gestion extends Model
{
    use HasFactory, Sortable;

    /**
     * Get the Produit associated with the Gestion.
     */
    public function produit(): BelongsTo
    {
        return $this->belongsTo(Produit::class);
    }

    /**
     * Get the Produits associated with the Gestion.
     */
    public function produits(): BelongsToMany
    {
        return $this->belongsToMany(Produit::class)->withPivot('quantite', 'unite');
    }

    public function getUniteVente()
    {
         return Produit::getUniteVenteStat($this->unite);
    }

    protected $fillable = ['produit_id', 'unite', 'quantite', 'date_mouvement'];
    protected $sortable = ['produit', 'unite', 'quantite'];
    protected $casts = [
        'date_mouvement' => 'datetime',
    ];
}
