<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProduitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'referenceB' =>'nullable|unique:produits|string',
            'site' => 'string',
            'famille' => 'required|string|max:50',
		    'type' => 'nullable|string',
		    'essence' => 'nullable|string',
		    'qualite' => 'nullable|string',
            'unite' => 'string',
		    'epaisseur' => 'nullable|integer',
		    'largeur' => 'nullable|integer',
		    'longueur' => 'nullable|integer',
		    'humidite' => 'nullable|integer',
		    'origine' => 'string',
            'analytiqueA' => 'nullable|string',
            'analytiqueB' => 'nullable|string',
            'analytiqueC' => 'nullable|string'
	];
    }
}
