<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreTarifRequest;
use App\Http\Requests\UpdateTarifRequest;
use App\Models\Tarif;
use App\Models\Produit;
use Illuminate\Support\Facades\DB;

class TarifController extends Controller {
    /**
     * Display a listing of the resource.
     */
    public function index() {
        return view('tarifs.index', ['datas' => Tarif::all() ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create() {
        return view('tarifs.create', [
            'produits' => Produit::all()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreTarifRequest $request) {
        Tarif::create($request->all());
	    return redirect()->route('tarifs.index')
                ->withSuccess('Nouveau Tarif ajoutée avec succès.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Tarif $tarif)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Tarif $tarif)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateTarifRequest $request, Tarif $tarif)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Tarif $tarif) {
	    $tarif->delete();
        return redirect()->route('tarifs.index')
                ->withSuccess('Le Tarifs pour cette période a été correctement supprimé.');
    }
}
