<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreStockRequest;
use App\Http\Requests\UpdateStockRequest;
use App\Models\Stock;
use App\Models\Produit;
use App\Models\Colis;
use Illuminate\Support\Facades\DB;

class StockController extends Controller {
    /**
     * Display a listing of the resource.
     */
    public function index(){
//-----
$qA = Stock::select(DB::raw('produit_id , stocks.unite as unite_en_stock, SUM(quantite) as total_vendable'))
->leftJoin('produits', 'produit_id', '=', 'produits.id')
->groupBy('produit_id', 'unite_en_stock')
//->where('produit_id', $produit->id)
;

$qB = DB::table("inventaires")->select(['produit_id' , 'inventaires.unite as unite_en_stock', 'quantite as total_vendable'])
->leftJoin('produits', 'produit_id', '=', 'produits.id')
->orderBy('date', 'DESC')
//->where('produit_id', $produit->id)
//->take(1)
;

$qC = $qA->union($qB);

$quantites = DB::query()->fromSub($qC, 'test')
->select( DB::raw('produit_id , referenceA , alternatif, famille, type, essence, qualite, epaisseur, largeur, longueur, humidite, origine, produits.unite as unite_vente, unite_en_stock, SUM(total_vendable) as total_vendable') )
->rightJoin('produits', 'produit_id', '=', 'produits.id')
->groupBy('produit_id', 'unite_en_stock', 'referenceA', 'alternatif', 'famille', 'type', 'essence', 'qualite', 'epaisseur', 'largeur', 'longueur', 'humidite', 'origine', 'unite_vente')
->orderBy('referenceA')
->get();


//------

        /*$quantites = DB::table('stocks')
                ->select(DB::raw('produit_id, produits.* , SUM(quantite) as total_vendable'))
                ->joinLeft('produits', 'stocks.produit_id', '=', 'produits.id')
                ->groupBy('produit_id')
                ->get();*/
/*
        $quantites = Stock::select(DB::raw('produit_id ,referenceA, SUM(quantite) as total_vendable'))
                ->leftJoin('produits', 'stocks.produit_id', '=', 'produits.id')
                ->groupBy('produit_id', 'referenceA')
                ->get();
*/
        return view('stocks.index', ['datas' => Stock::sortable()->paginate(30), 'quantites'=>$quantites ]);
        //return view('stocks.index', ['datas' => Stock::sortable()->paginate(30) ]);

    }

    public function chiffre(){
        $qA = Stock::select(DB::raw('stocks.produit_id as produit_id, stocks.unite as unite_en_stock, SUM(quantite) as total_vendable'))
        ->leftJoin('produits', 'stocks.produit_id', '=', 'produits.id')
        ->groupBy('produit_id', 'unite_en_stock') ;
        
        $qB = DB::table("inventaires")->select(['inventaires.produit_id as produit_id' , 'inventaires.unite as unite_en_stock', 'quantite as total_vendable'])
        ->leftJoin('produits', 'inventaires.produit_id', '=', 'produits.id')
        ->orderBy('date', 'DESC') ;
        
        $qC = $qA->union($qB);
        
        $quantites = DB::query()->fromSub($qC, 'test')
        ->select( DB::raw('test.produit_id , referenceA , alternatif, famille, type, essence, qualite, epaisseur, largeur, longueur, humidite, origine, produits.unite as unite_vente, unite_en_stock, prix_revient, prix_negociant, SUM(total_vendable) as total_vendable') )
        ->rightJoin('produits', 'test.produit_id', '=', 'produits.id')
        ->leftJoin('tarifs', 'tarifs.produit_id', '=', 'test.produit_id')
        ->groupBy('produit_id', 'unite_en_stock', 'referenceA', 'alternatif', 'famille', 'type', 'essence', 'qualite', 'epaisseur', 'largeur', 'longueur', 'humidite', 'origine', 'unite_vente', 'prix_revient', 'prix_negociant')
        ->get();
        
        return view('stocks.chiffre', ['datas' => Stock::sortable()->paginate(30), 'quantites'=>$quantites ]);
    }


    public function complet(){
        /*$quantites = DB::table('stocks')
                ->select(DB::raw('produit_id, produits.* , SUM(quantite) as total_vendable'))
                ->joinLeft('produits', 'stocks.produit_id', '=', 'produits.id')
                ->groupBy('produit_id')
                ->get();*/
        $quantites = Stock::select(DB::raw('produit_id ,referenceA, SUM(quantite) as total_vendable'))
                ->leftJoin('produits', 'stocks.produit_id', '=', 'produits.id')
                ->groupBy('produit_id', 'referenceA')
                ->get();
        return view('stocks.complet', ['datas' => Stock::sortable()->paginate(30), 'quantites'=>$quantites ]);
        //return view('stocks.index', ['datas' => Stock::sortable()->paginate(30) ]);

    }

    /**
     * Show the form for creating a new resource.
     */
    public function create() {
        return view('stocks.create', [
            'produits' => Produit::all(),
            'coliss' => Colis::all()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreStockRequest $request) {
        Stock::create($request->all());
	    return redirect()->route('stocks.index')
                ->withSuccess('Nouveau mouvement de stock ajoutée avec succes.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Stock $stock)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Stock $stock)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateStockRequest $request, Stock $stock)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Stock $stock) {
	    $stock->delete();
        return redirect()->route('stocks.complet')
                ->withSuccess('Le mouvement de Stock a été correctement supprimé.');
    }
}
