<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreProduitRequest;
use App\Http\Requests\UpdateProduitRequest;
use App\Models\Stock;
use App\Models\Produit;
use App\Models\Essence;
use App\Models\Inventaire;
use Illuminate\Support\Facades\DB;

class ProduitController extends Controller {
    /**
     * Display a listing of the resource.
     */
    public function index() {
        return view('produits.index', ['produits' => Produit::all()->sortBy('referenceA') ]);
        //	    return view('produits.index', ['produits' => Produit::latest()->paginate(30) ]);
//        return view('produits.index', ['produits' => Produit::sortable()->paginate(30) ]);
        //return view('produits.index', ['produits' => Produit::sortable()->latest() ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create() {
	    return view('produits.create', [
            'lesessences' => Essence::all()
        ]);
    }
    public function createplus() {
	    return view('produits.createplus', [
            'lesessences' => Essence::all()
        ]);
    }
    
    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreProduitRequest $request) {
	    Produit::create($request->all());
	    return redirect()->route('produits.index')
                ->withSuccess('Nouveau produit ajouté avec succes.');
    }

    public function storeplus(StoreProduitRequest $request) {
	    $produit = Produit::create($request->all());
        Inventaire::create([
            'produit_id' => $produit->id,
            'quantite' => $request->quantite,
            'unite' => $request->unite
        ]);
	    return redirect()->route('produits.index')
                ->withSuccess('Nouveau produit ajouté avec succes, Inventaire renseigné au 31/12/2023');
    }

    /**
     * Display the specified resource.
     */
    public function show(Produit $produit) {
        /*$quantites = Stock::select(DB::raw('produit_id , stocks.unite as unite_en_stock, SUM(quantite) as total_vendable'))
        ->groupBy('produit_id', 'unite_en_stock')
        ->where('produit_id', $produit->id)
        ->get();
*/
        $qA = Stock::select(DB::raw('produit_id , stocks.unite as unite_en_stock, SUM(quantite) as total_vendable'))
        ->groupBy('produit_id', 'unite_en_stock')
        ->where('produit_id', $produit->id);

/*        $qB = Inventaire::select(DB::raw('produit_id , unite as unite_en_stock, SUM(quantite) as total_vendable'))
        ->groupBy('produit_id', 'unite_en_stock')
        ->where('produit_id', $produit->id);*/

        //$qB = Inventaire::
        $qB = DB::table("inventaires")->select(['produit_id' , 'unite as unite_en_stock', 'quantite as total_vendable'])
        ->orderBy('date', 'DESC')
        ->where('produit_id', $produit->id)
        ->take(1);

        //Inventaire::where('produit_id', $produit->id)->get()

        $qC = $qA->union($qB);

        $quantites = DB::query()->fromSub($qC, 'test')
        ->select( DB::raw('produit_id , unite_en_stock, SUM(total_vendable) as total_vendable') )
        ->groupBy('produit_id', 'unite_en_stock')
        ->get();

	    return view('produits.show', [ 
            'produit' => $produit,
            'inventaires' => Inventaire::where('produit_id', $produit->id)->get(),
            'quantites' => $quantites
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Produit $produit) {
	    return view('produits.edit', [
            'produit' => $produit,
            'lesessences' => Essence::all()
        ]);
    }

    public function editplus(Produit $produit) {
        $inventaire = Inventaire::where('produit_id', '=', $produit->id)->get()->first();
        if(null == $inventaire) {
            $inventaire = Inventaire::create([
                'produit_id' => $produit->id,
                'quantite' => 0,
                'unite' => $produit->unite
            ]);
        }

	    return view('produits.editplus', [
            'produit' => $produit,
            'lesessences' => Essence::all(),
            'inventaire' => $inventaire
        ]);
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateProduitRequest $request, Produit $produit)
    {
        $produit->update( $request->all() );
        //return redirect()->back()
        return redirect()->route('produits.index')
                ->withSuccess('Le Produit a été mis à jours correctement.');
    }

    public function updateplus(UpdateProduitRequest $request, Produit $produit) {
        $inventaire = Inventaire::where('produit_id', '=', $produit->id)->get()->first();
        $inv = [
            'quantite' => $request->quantite,
            'localisation' => $request->localisation
        ];
        $inventaire->update($inv);
        $produit->update( $request->all() );
        //return redirect()->back()
        return redirect()->route('produits.index')
                ->withSuccess('Le Produit et l\'Inventaire a été mis à jours correctement.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Produit $produit)
    {
	    $produit->delete();
        return redirect()->route('produits.index')
                ->withSuccess('Le Produit a été correctement supprimé.');
    }
}
