<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\StoreGestionRequest;
use App\Http\Requests\UpdateGestionRequest;
use App\Models\Gestion;
use App\Models\Produit;
use App\Models\Stock;


class GestionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        // Récupérer la date spécifiée à partir de la requête
        $date_mouvement = $request->input('date_mouvement', date('Y-m-d'));
    
        // Récupérer le stock correspondant à la date spécifiée
        $stock = Stock::with('produit')
            //->where('produits.site', "!=", "Loubejac")
            ->whereHas('produit', function($query) {
                $query->where('site', '!=', 'Loubejac');
            })->orderBy("date_mouvement", 'desc')
            ->get();
    
        // Autres données dont vous pourriez avoir besoin
        $produits = Produit::all();
    
        return view('gestions.index', compact('stock', 'produits', 'date_mouvement'));
    }
    
    
    

    /**
     * Show the form for creating a new resource.
     */
    public function create($date = null)
    {
        // Utilisez la date fournie dans l'URL ou la date actuelle si aucune date n'est fournie
        $date = $date ?? now()->toDateString();
    
        $stocksDuJour = Stock::with('produit')
            ->whereDate('date_mouvement', $date)
            ->get();
    
        $produits = Produit::all();
    
        $gestions = Stock::with('produit')
            ->whereDate('date_mouvement', $date)
            ->orderBy('date_mouvement', 'desc')
            ->get();
    
        return view('gestions.create', compact('gestions', 'stocksDuJour', 'produits', 'date'));
    }
    
    
    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreGestionRequest $request) {
        Stock::create($request->all());
        return redirect()->route('gestions.create')
                ->withSuccess("Gestion créée avec succès.");
    }

    /**
     * Display the specified resource.
     */
    public function show(Gestion $gestion)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Gestion $gestion)
    {
        return view('gestions.edit', [
            'gestion' => $gestion,
            'produits' => Produits::all()
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateGestionRequest $request, Gestion $gestion) {
        $gestion->update($request->all());
        return redirect()->route('gestions.index')
                ->withSuccess("Gestion mise à jour avec succès.");
    }

    /**
     * Remove the specified resource from storage.
     */
    // GestionController.php

  // GestionController.php

  public function destroy(Stock $stock)

  {
    $stock->delete();
    // Utilisez la date fournie dans l'URL ou la date actuelle si aucune date n'est fournie
    $date = $date ?? now()->toDateString();
    
    $stocksDuJour = Stock::with('produit')
        ->whereDate('date_mouvement', $date)
        ->get();

    $produits = Produit::all();

    $gestions = Stock::with('produit')
        ->whereDate('date_mouvement', $date)
        ->orderBy('date_mouvement', 'desc')
        ->get();

    
    
      return view('gestions.create', compact('gestions', 'stocksDuJour', 'produits', 'date'))
              ->withSuccess('Le Produit a été correctement supprimé.');

  }

    
}
