<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class FourtriController extends Controller
{
    public function index()
    {
        $fours = Four::all();
        return view('fours.index', compact('fours'));
    }

    public function create()
    {
        return view('fours.create');
    }

    public function store(Request $request)
    {
        // Validation des données du formulaire
        $request->validate([
            'nom' => 'required|string|max:255',
            'date_entree' => 'required|date',
            'date_sortie_estimee' => 'required|date'
        ]);

        // Création d'un nouveau four
        Four::create($request->all());

        return redirect()->route('fours.index')->with('success', 'Four créé avec succès.');
    }
}
