<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center mt-3">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <div class="float-start">
                        Production du
                        <?php if(!empty($date)): ?>
                            <?php echo e(strftime('%A %e %B %Y', strtotime($date))); ?>

                        <?php endif; ?>
                    </div>
                    <div class="float-end">
                        <a href="<?php echo e(route('gestions.index')); ?>" class="btn btn-info btn-sm">&larr; Retour</a>
                        
                    </div>
                </div>
                <div class="card-body">
                    <?php if($gestions->isEmpty()): ?>
                        <p>Aucune production enregistrée pour ce jour.</p>
                    <?php else: ?>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">Produit</th>
                                    <th scope="col">Quantité</th>
                                    <th scope="col"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $gestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gestion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($gestion->produit->referenceA); ?></td>

                                        <td class="text-center"><?php echo e($gestion->quantite * 1); ?> <?php echo e($gestion->unite); ?></td>
                                        <td>
                                            <form action="<?php echo e(route('gestions.destroy', $gestion->id)); ?>" method="post" id="deleteForm_<?php echo e($gestion->id); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce produit en stock ?')">
                                                    <i class="bi bi-trash"></i> 
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                    
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
                <form action="<?php echo e(route('gestions.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                   <input type="hidden" name="date" value="<?php echo e($date); ?>"> 
                    <!-- Ajoutez d'autres champs du formulaire ici -->

                 
                  
                    <div class="mb-3 row">
                        <label for="famille" class="col-md-4 col-form-label text-md-end text-start">La Famille</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['famille'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="famille" id="famille">
                                <?php $__currentLoopData = $familles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $famille): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($famille); ?>" <?php if(old('famille') == $famille): ?> selected <?php endif; ?>><?php echo e($famille); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['famille'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['produit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="produit_id" id="produit_id">
                                <?php $__currentLoopData = $produits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($produit->id); ?>" <?php if(old('produit_id') == $produit->referenceA): ?> selected="selected" <?php endif; ?>>
                                        <?php echo e($produit->referenceA.' - '); ?>

                                        <?php if(null != $produit->alternatif || '' != $produit->alternatif): ?>
                                            <?php echo e($produit->alternatif); ?>

                                        <?php else: ?>
                                            <?php echo e($produit->getDescriptifFullOrAlter()); ?>

                                        <?php endif; ?>
                                    </option>  
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('produit_id')): ?>
                                <span class="text-danger"><?php echo e($errors->first('produit_id')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>


                    <script type="text/javascript" >
                            $(document).ready(function() {
                                $('.select2').select2();
                            })
                    </script>

                    <script type="text/javascript" >
                        function updateProduitsOptions() {
   // alert("Bonjour");
    var famille = document.getElementById('famille').value;
    var produits = <?php echo ($produits); ?>; // Charger tous les produits dans une variable JavaScript

    console.log("Famille sélectionnée :", famille);
    console.log("Produits chargés :", produits);

    // Filtrer les produits en fonction de la famille sélectionnée
    var produitsFiltres = produits.filter(function(produit) {
        console.log("Produit sélectionné :", produit.referenceA, produit.famille);
        return produit.famille === famille;
    });

    console.log("Produits filtrés :", produitsFiltres);

    // Mettre à jour les options du champ 'produit_id'
    var produitSelect = document.getElementById('produit_id');
    produitSelect.innerHTML = ''; // Effacer les options actuelles

    // Ajouter les options correspondant à la famille sélectionnée
    produitsFiltres.forEach(function(produit) {
        console.log("Produit :", produit);
        var option = document.createElement('option');
        option.value = produit.id;
        option.textContent = produit.referenceA; // Assurez-vous que cette propriété est correcte
        produitSelect.appendChild(option);
    });
}





                    $(document).ready(function() {
                        $('.select2').select2();
                        updateProduitsOptions(); // Appel de la fonction ici
                    });

                    // Gestionnaire d'événements onchange pour mettre à jour les options lorsque la famille est modifiée
                    $('#famille').on('change', function() {
                        updateProduitsOptions();
                    });
                    </script>







                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité produite</label>
                        <div class="col-md-6">
                            <input type="text" class="form-control <?php $__errorArgs = ['quantite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="quantite" name="quantite" value="<?php echo e(old('quantite')); ?>">
                            <?php $__errorArgs = ['quantite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>


                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['unite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="unite" id="unite">
                                <?php $__currentLoopData = ['Palette', 'm3', 'Stère', 'Pile', 'ml', 'Pièce', 'Kilo', 'Rouleau', 'm2']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($option); ?>" <?php if(old('unite') == $option): ?> selected <?php endif; ?>><?php echo e($option); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['unite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                    </div>

            

                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-secondary" value="Ajouter le Produit">
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function confirmDelete(gestionId) {
        console.log('Confirm delete function called with ID:', gestionId);
        var isConfirmed = confirm('Êtes-vous sûr de vouloir supprimer ce produit en stock ?');
        console.log('Confirmation status:', isConfirmed);

        if (isConfirmed) {
            // Supprimer le produit en stock
            document.getElementById('deleteForm_' + gestionId).submit();
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.btn-confirm-delete').forEach(function (button) {
            button.addEventListener('click', function () {
                var gestionId = this.getAttribute('data-gestion-id');
                confirmDelete(gestionId);
            });
        });
    });


  
    
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('gestions.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/DevIntranetFontenoyBois/resources/views/gestions/create.blade.php ENDPATH**/ ?>