<?php $__env->startSection('content'); ?>

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success" role="alert">
                <?php echo e($message); ?>

            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">Liste des Clients</div>
            <div class="card-body">
                <a href="<?php echo e(route('clients.create')); ?>" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter un Client au fichier</a>
                <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th scope="col">S#</th>
                        <th scope="col">Code</th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('nom', 'Nom'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('email', 'Email'));?></th>
                        <th scope="col">Raison sociale</th>
                        <th scope="col">Adresse</th>
                        <th scope="col">Cp</th>
                        <th scope="col">Ville</th>
                        <th scope="col">Siret</th>
                        <th scope="col">Tel</th>
                        <th scope="col">Contact</th>
                        <th scope="col">Mobile</th>
                        <th scope="col">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td scope="row"><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($data->code_client); ?></td>
                            <td><?php echo e($data->nom); ?></td>
                            <td><?php echo e($data->email); ?></td>
                            <td><?php echo e($data->raison_sociale); ?></td>
                            <td><?php echo e($data->adresse); ?></td>
                            <td><?php echo e($data->cp); ?></td>
                            <td><?php echo e($data->ville); ?></td>
                            <td><?php echo e($data->siret); ?></td>
                            <td><?php echo e($data->telephone); ?></td>
                            <td><?php echo e($data->contact); ?></td>
                            <td><?php echo e($data->mobile); ?></td>
                            <td>
                                <form action="<?php echo e(route('clients.destroy', $data->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>

                                    <!-- <a href="<?php echo e(route('clients.show', $data->id)); ?>" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a> -->
                                    <a href="<?php echo e(route('clients.edit', $data->id)); ?>" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif</a>
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer ce Client ?');"><i class="bi bi-trash"></i> Suppr</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="13">
                                <span class="text-danger">
                                    <strong>Aucun clients!</strong>
                                </span>
                            </td>
                        <?php endif; ?>
                    </tbody>
                  </table>

                  <?php echo e($datas->withQueryString()->links()); ?>


            </div>
        </div>
    </div>    
</div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('clients.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/IntranetFontenoyBois/resources/views/clients/index.blade.php ENDPATH**/ ?>