<?php $__env->startSection('content'); ?>

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success" role="alert">
                <?php echo e($message); ?>

            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">Etat des stocks : vue détaillée avec tous les mouvements</div>
            <div class="card-body">
                <a href="<?php echo e(route('stocks.create')); ?>" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter un mouvement de stock</a>
                <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('produit.referenceA', 'Ref'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('produit.famille', 'Famille'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('produit.type', 'Type'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('produit.essence', 'Essence'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('produit.qualite', 'Qualité'));?></th>
                        <th scope="col">Epaisseur</th>
                        <th scope="col">Largeur</th>
                        <th scope="col">Longueur</th>
                        <th scope="col">Humidité</th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('origine', 'Origine'));?></th>
                        <th scope="col">Date</th>
                        <th scope="col">Quantité</th>
                        <th scope="col">Colissage</th>
                        <th scope="col">Motif</th>
                        <th scope="col">Action</th>
                     </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php $produit = $data->produit()->first(); ?>
                        <tr class="<?php if($data->quantite>=0): ?> table-success <?php else: ?> table-danger <?php endif; ?>">
                            <td><?php echo e($produit->referenceA); ?></td>
                            <?php if(null == $produit->alternatif || '' == $produit->alternatif): ?>
                            <td><?php echo e($produit->famille); ?></td>
                            <td><?php echo e($produit->type); ?></td>
                            <td><?php echo e($produit->essence); ?></td>
                            <td><?php echo e($produit->qualite); ?></td>
                            <td><?php if($produit->epaisseur>0): ?> <?php echo e($produit->epaisseur); ?> <?php else: ?> &nbsp; <?php endif; ?></td>
                            <td><?php if($produit->largeur>0): ?> <?php echo e($produit->largeur); ?> <?php else: ?> &nbsp; <?php endif; ?></td>
                            <td><?php if($produit->longueur>0): ?> <?php echo e($produit->longueur); ?> <?php else: ?> &nbsp; <?php endif; ?></td>
                            <td><?php echo e($produit->humiditeLabel()); ?></td>
                            <td><?php echo e($produit->origine); ?></td>
                            <?php else: ?>
                            <td colspan="9"><?php echo e($produit->alternatif); ?></td>
                            <?php endif; ?>
                            <td><?php echo e($data->date_mouvement->format('d-m-Y')); ?></td>
                            <td><?php echo e($data->quantite); ?>&nbsp;<?php echo e($data->unite); ?></td>
                            <td>
                                <?php if($data->colis()->first()): ?>
                                    <?php echo e($data->nombre_colis .' ' .$data->colis()->first()->getDescriptifLight()); ?>

                                <?php else: ?>
                                    &nbsp;
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($data->motif); ?></td>
                            <td>
                                <form action="<?php echo e(route('stocks.destroy', $data->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>

                                    <!-- <a href="<?php echo e(route('stocks.show', $data->id)); ?>" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a> -->
                                    <!-- <a href="<?php echo e(route('stocks.show', $data->id)); ?>" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a> -->

                                    <!-- <a href="<?php echo e(route('stocks.edit', $data->id)); ?>" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif</a> -->

                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer ce Mouvement de Stock (Irreversible) ?');"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                       </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="13">
                                <span class="text-danger">
                                    <strong>Aucun inventaire!</strong>
                                </span>
                            </td>
                        <?php endif; ?>

                    </tbody>
                  </table>

                  <?php echo e($datas->withQueryString()->links()); ?>


            </div>
        </div>
    </div>    
</div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('stocks.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/IntranetFontenoyBois/resources/views/stocks/complet.blade.php ENDPATH**/ ?>