<?php $__env->startSection('content'); ?>

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success" role="alert">
                <?php echo e($message); ?>

            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">Liste des commandes</div>
            <div class="card-body">
                <a href="<?php echo e(route('commandes.create')); ?>" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter une commande</a>
                <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th scope="col">S#</th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('date_commande', 'Date'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('client.nom', 'Client'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('produit.referenceA', 'Ref'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('produit.famille', 'Famille'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('produit.type', 'Type'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('origine', 'Origine'));?></th>
                        <th scope="col">Quantité</th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('date_annonce', 'Date Annoncée'));?></th>
                        <th scope="col"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('statut', 'Statut'));?></th>
                        <th scope="col">Observations</th>
                        <th scope="col">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php 
                            $produit = $data->produit()->first(); 
                            $client = $data->client()->first(); 
                            ?>
                        <tr>
                            <th scope="row"><?php echo e($loop->iteration); ?></th>
                            <td><?php echo e($data->date_commande); ?></td>
                            <td><?php echo e($client->nom); ?></td>
                            <td><?php echo e($produit->referenceA); ?></td>
                            <?php if(null == $produit->alternatif || '' == $produit->alternatif): ?>
                            <td><?php echo e($produit->famille); ?></td>
                            <td><?php echo e($produit->type); ?></td>
                            <td><?php echo e($produit->origine); ?></td>
                            <?php else: ?>
                            <td colspan="3"><?php echo e($produit->alternatif); ?></td>
                            <?php endif; ?>
                            <td><?php echo e($data->quantite); ?>&nbsp;<?php echo e($data->unite); ?></td>
                            <td><?php echo e($data->date_annonce); ?></td>
                            <td><?php echo e($data->statut); ?></td>
                            <td><?php echo e($data->observations); ?></td>
                            <td>
                                <form action="<?php echo e(route('commandes.destroy', $data->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>

                                    <!-- <a href="<?php echo e(route('commandes.show', $data->id)); ?>" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a> -->
                                    <a href="<?php echo e(route('commandes.edit', $data->id)); ?>" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif</a>

                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer cette Commande ?');"><i class="bi bi-trash"></i> Suppr</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="13">
                                <span class="text-danger">
                                    <strong>Aucune commande!</strong>
                                </span>
                            </td>
                        <?php endif; ?>
                    </tbody>
                  </table>

                  <?php echo e($datas->withQueryString()->links()); ?>


            </div>
        </div>
    </div>    
</div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('commandes.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/IntranetFontenoyBois/resources/views/commandes/index.blade.php ENDPATH**/ ?>