<?php $__env->startSection('content'); ?>

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success" role="alert">
                <?php echo e($message); ?>

            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">Etat des stocks : vue consolidée par Références</div>
            <div class="card-body">
                <a href="<?php echo e(route('stocks.create')); ?>" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter un mouvement de stock</a>

                  <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th scope="col">S#</th>
                        <th scope="col">Ref</th>
                        <th scope="col">Famille</th>
                        <th scope="col">Type</th>
                        <th scope="col">Essence</th>
                        <th scope="col">Qualité</th>
                        <th scope="col">Epaisseur</th>
                        <th scope="col">Largeur</th>
                        <th scope="col">Longueur</th>
                        <th scope="col">Humidité</th>
                        <th scope="col">Origine</th>
                        <th scope="col">Quantité</th>
                      </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $quantites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php if($data->total_vendable>0): ?> table-success <?php elseif($data->total_vendable<0): ?> table-danger <?php else: ?> table-warning  <?php endif; ?>">
                            <th scope="row"><?php echo e($loop->iteration); ?></th>
                            <td><?php echo e($data->referenceA); ?></td>
                            <?php if(null == $data->alternatif || '' == $data->alternatif): ?>
                            <td><?php echo e($data->famille); ?></td>
                            <td><?php echo e($data->type); ?></td>
                            <td><?php if( $data->essence == '--N/A--'): ?> &nbsp; <?php else: ?> <?php echo e($data->essence); ?><?php endif; ?></td>
                            <td><?php echo e($data->qualite); ?></td>
                            <td><?php if($data->epaisseur>0): ?> <?php echo e($data->epaisseur); ?> <?php else: ?> &nbsp; <?php endif; ?></td>
                            <td><?php if($data->largeur>0): ?> <?php echo e($data->largeur); ?> <?php else: ?> &nbsp; <?php endif; ?></td>
                            <td><?php if($data->longueur>0): ?> <?php echo e($data->longueur); ?> <?php else: ?> &nbsp; <?php endif; ?></td>
                            <td><?php echo e(App\Models\Produit::humiditeLabelStat($data->humidite)); ?></td>
                            <td><?php echo e($data->origine); ?></td>
                            <?php else: ?>
                            <td colspan="9"><?php echo e($data->alternatif); ?></td>
                            <?php endif; ?>
                            <td style="text-align:right"><?php if($data->total_vendable!=0): ?><?php echo e($data->total_vendable * 1); ?>&nbsp;<?= App\Models\Produit::getUniteVenteStat($data->unite_en_stock) ?><?php endif; ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="13">
                                <span class="text-danger">
                                    <strong>Aucun inventaire!</strong>
                                </span>
                            </td>
                        <?php endif; ?>
                    </tbody>
                  </table>

                  <?php echo e($datas->withQueryString()->links()); ?>



            </div>
        </div>
    </div>    
</div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('stocks.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/IntranetFontenoyBois/resources/views/stocks/index.blade.php ENDPATH**/ ?>