<?php

use App\Http\Controllers\ProfileController;

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


use App\Http\Controllers\UserController;

Route::get('/create-user-with-role', [UserController::class, 'createUserWithRole']);



use App\Http\Controllers\GestionController;

Route::get('/gestions', [GestionController::class, 'index'])->name('gestions.index')->middleware(['auth', 'verified']);
Route::get('/gestions/create/{date?}', [GestionController::class, 'create'])->name('gestions.create')->middleware(['auth', 'verified']);
Route::get('/gestions/{gestion}', [GestionController::class, 'show'])->name('gestions.show')->middleware(['auth', 'verified']);
Route::put('/gestions/{gestion}', [GestionController::class, 'update'])->name('gestions.update')->middleware(['auth', 'verified']);
Route::delete('/gestions/{stock}', [GestionController::class, 'destroy'])->name('gestions.destroy')->middleware(['auth', 'verified']);
Route::get('/gestions/edit/{date?}', [GestionController::class, 'edit'])->name('gestions.edit')->middleware(['auth', 'verified']);
Route::put('/gestions/{gestion}', [GestionController::class, 'update'])->name('gestions.update')->middleware(['auth', 'verified']);
Route::post('/gestions/store', [GestionController::class, 'store'])->name('gestions.store')->middleware(['auth', 'verified']);



use App\Http\Controllers\ProduitController;
Route::get('/produits/createplus', [ProduitController::class, 'createplus'])->name('produits.createplus')->middleware(['auth', 'verified']);
Route::get('/produits/{produit}/editplus', [ProduitController::class, 'editplus'])->name('produits.editplus')->middleware(['auth', 'verified']);
Route::post('/produits/storeplus', [ProduitController::class, 'storeplus'])->name('produits.storeplus')->middleware(['auth', 'verified']);
Route::put('/produits/updateplus/{produit}', [ProduitController::class, 'updateplus'])->name('produits.updateplus')->middleware(['auth', 'verified']);
Route::resource('/produits', ProduitController::class)->middleware(['auth', 'verified']);


use App\Http\Controllers\InventaireController;
Route::get('/inventaires/chiffre', [InventaireController::class, 'chiffre'])->name('inventaires.chiffre')->middleware(['auth', 'verified']);
Route::resource('/inventaires', InventaireController::class)->middleware(['auth', 'verified']);

use App\Http\Controllers\ClientController;
Route::resource('/clients', ClientController::class)->middleware(['auth', 'verified']);

use App\Http\Controllers\CommandeController;
Route::resource('/commandes', CommandeController::class)->middleware(['auth', 'verified']);

use App\Http\Controllers\StockController;
Route::get('/stocks/chiffre', [StockController::class, 'chiffre'])->name('stocks.chiffre')->middleware(['auth', 'verified']);
Route::get('/stocks/complet', [StockController::class, 'complet'])->name('stocks.complet')->middleware(['auth', 'verified']);
Route::resource('/stocks', StockController::class)->middleware(['auth', 'verified']);

use App\Http\Controllers\TarifController;
Route::resource('/tarifs', TarifController::class)->middleware(['auth', 'verified']);



Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware(['role:administrateur'])->group(function () {
    // Routes accessibles uniquement aux administrateurs
    Route::get('/admin/dashboard', 'UserController@dashboard');
});

Route::middleware(['role:magasinier'])->group(function () {
    // Routes accessibles uniquement aux magasiniers
    Route::get('/magasinier/inventory', 'UserController@inventory');
});
Route::middleware(['role:responsable'])->group(function () {
    // Routes accessibles uniquement aux administrateurs
    Route::get('/responsable/some-method', 'UserController@someMethod');
});

Route::middleware(['role:commercial'])->group(function () {
    // Routes accessibles uniquement aux magasiniers
    Route::get('/commercial/dashboard', 'UserController@dashboard');
});

require __DIR__.'/auth.php';
