@extends('tarifs.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                Définir le Prix d'un Produit pour une période donnée.
                </div>
                <div class="float-end">
                    <a href="{{ route('tarifs.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('tarifs.store') }}" method="post">
                    @csrf

                    <div class="mb-3 row">
                        <label for="date_debut" class="col-md-4 col-form-label text-md-end text-start">Date Début</label>
                        <div class="col-md-6">
                          <input type="date" class="form-control @error('date_debut') is-invalid @enderror" id="date_debut" name="date_debut" value="{{ old('date_debut') ?? '2023-12-31' }}">
                            @if ($errors->has('date_debut'))
                                <span class="text-danger">{{ $errors->first('date_debut') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="date_fin" class="col-md-4 col-form-label text-md-end text-start">Date Fin</label>
                        <div class="col-md-6">
                          <input type="date" class="form-control @error('date_debut') is-invalid @enderror" id="date_fin" name="date_fin" value="{{ old('date_fin') ?? '2024-06-30' }}">
                            @if ($errors->has('date_fin'))
                                <span class="text-danger">{{ $errors->first('date_fin') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                        <div class="col-md-6">
                            <select class="form-control @error('produit_id') is-invalid @enderror select2" name="produit_id" id="produit_id">
                                @foreach ($produits as $produit)
                                <option value="{{$produit->id}}" @if (old('produit_id') == $produit->id) selected="selected" @endif>{{ $produit->referenceA . ' - ' . $produit->getDescriptifFullOrAlter() }}</option>  
                                @endforeach
                            </select>
                            @if ($errors->has('produit_id'))
                                <span class="text-danger">{{ $errors->first('produit_id') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="prix_revient" class="col-md-4 col-form-label text-md-end text-start">Prix de revient</label>
                        <div class="col-md-6">
                          <input type="number" class="form-control @error('prix_revient') is-invalid @enderror" id="prix_revient" name="prix_revient" value="{{ old('prix_revient') }}" step="any">
                            @if ($errors->has('prix_revient'))
                                <span class="text-danger">{{ $errors->first('prix_revient') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="prix_negociant" class="col-md-4 col-form-label text-md-end text-start">Prix Négociant</label>
                        <div class="col-md-6">
                          <input type="number" class="form-control @error('prix_revient') is-invalid @enderror" id="prix_negociant" name="prix_negociant" value="{{ old('prix_negociant') }}" step="any">
                            @if ($errors->has('prix_negociant'))
                                <span class="text-danger">{{ $errors->first('prix_negociant') }}</span>
                            @endif
                        </div>
                    </div>
                    <script type="text/javascript" >
    $(document).ready(function() {
        $('.select2').select2();
    })
</script>
                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Valider le Mouvement">
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
