@extends('stocks.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                Ajouter un mouvement au stock
                </div>
                <div class="float-end">
                    <a href="{{ route('stocks.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('stocks.store') }}" method="post">
                    @csrf

                    <div class="mb-3 row">
                        <label for="date_mouvement" class="col-md-4 col-form-label text-md-end text-start">Date</label>
                        <div class="col-md-6">
                          <input type="date" class="form-control @error('date_mouvement') is-invalid @enderror" id="date_mouvement" name="date_mouvement" value="{{ old('date_mouvement') ?? date('Y-m-d') }}">
                            @if ($errors->has('date_mouvement'))
                                <span class="text-danger">{{ $errors->first('date_mouvement') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                        <div class="col-md-6">
                            <select class="form-control @error('produit_id') is-invalid @enderror select2" name="produit_id" id="produit_id">
                                @foreach ($produits as $produit)
                                <option value="{{$produit->id}}" @if (old('produit_id') == $produit->id) selected="selected" @endif>{{ $produit->referenceA . ' - ' . $produit->getDescriptifFullOrAlter() }}</option>  
                                @endforeach
                            </select>
                            @if ($errors->has('produit_id'))
                                <span class="text-danger">{{ $errors->first('produit_id') }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité à ajouter (en +) à retirer (en -) </label>
                        <div class="col-md-6">
                          <input type="number" class="form-control @error('quantite') is-invalid @enderror" id="quantite" name="quantite" value="{{ old('quantite') }}" step="any">
                          <span id="infosurface" class="badge badge-primary badge-pill text-primary"></span>
                            @if ($errors->has('quantite'))
                                <span class="text-danger">{{ $errors->first('quantite') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité de vente</label>
                        <div class="col-md-6">
                            <select class="form-control @error('unite') is-invalid @enderror" name="unite">
                                <option value="m2" @if (old('unite') == 'm2') selected="selected" @endif>m<sup>2</sup></option>
                                <option value="m3" @if (old('unite') == 'm3') selected="selected" @endif>m3</option>
                                <option value="Stère" @if (old('unite') == 'Stère') selected="selected" @endif>Stère</option>
                                <option value="Pile" @if (old('unite') == 'Pile') selected="selected" @endif>Pile</option>
                                <option value="ml" @if (old('unite') == 'ml') selected="selected" @endif>ml</option>
                                <option value="Pièce" @if (old('unite') == 'Pièce') selected="selected" @endif>Pièce</option>
                                <option value="Kilo" @if (old('unite') == 'Kilo') selected="selected" @endif>Kilo</option>
                                <option value="Rouleau" @if (old('unite') == 'rouleau') selected="selected" @endif>Rouleau</option>
                                <option value="Palette" @if (old('unite') == 'Palette') selected="selected" @endif>Palette</option>
                            </select>
                            @if ($errors->has('unite'))
                                <span class="text-danger">{{ $errors->first('unite') }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="mb-3 row">
                        <label for="motif" class="col-md-4 col-form-label text-md-end text-start">Motif</label>
                        <div class="col-md-6">
                            
                          <input type="text" class="form-control @error('motif') is-invalid @enderror" id="motif" name="motif" value="{{ old('motif') }}">                            
                            @if ($errors->has('motif'))
                                <span class="text-danger">{{ $errors->first('motif') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            Colissage (pour nos Parquets)
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <label for="colis_id" class="col-md-4 col-form-label text-md-end text-start">Le Colissage</label>
                                <div class="col-md-6">
                                    <select class="form-control @error('colis_id') is-invalid @enderror select2" name="colis_id" id="colis_id">
                                        <option value="" @if (old('colis_id') == '') selected="selected" @endif>Sans Objet</option>  
                                        @foreach ($coliss as $colis)
                                        <option value="{{$colis->id}}" @if (old('colis_id') == $colis->id) selected="selected" @endif>{{ $colis->getDescriptifFull() }}</option>  
                                        @endforeach
                                    </select>
                                    @if ($errors->has('colis_id'))
                                        <span class="text-danger">{{ $errors->first('colis_id') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="nombre_colis" class="col-md-4 col-form-label text-md-end text-start">Nombre de colis</label>
                                <div class="col-md-6">
                                    <input type="number" class="form-control @error('nombre_colis') is-invalid @enderror" id="nombre_colis" name="nombre_colis" value="{{ old('nombre_colis') }}">
                                    @if ($errors->has('nombre_colis'))
                                        <span class="text-danger">{{ $errors->first('nombre_colis') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Valider le Mouvement">
                    </div>
                    <script type="text/javascript" >
                        $(document).ready(function() {
                            $('.select2').select2();
  
                            if($('#colis_id').val() == '') {
                                $('#nombre_colis').attr('disabled', true);
                            } 

                            $('#colis_id').on('select2:selecting', function(e) {
                                //console.log('Selecting: ' , e.params.args.data);
                                if(e.params.args.data.id == '') {
                                    $('#nombre_colis').val('');
                                    $('#nombre_colis').attr('disabled', true);
                                } else {
                                    $('#nombre_colis').attr('disabled', false);
                                    majSurface(e);
                                    //$("#infosurface").html("! Les colis font : " + 127 + "m<sup>2</sup>");
                                    //$("#quantite").prop("readonly", true);
                                }
                            });

                            $('#nombre_colis').on('keyup', majSurface);
                            $('#nombre_colis').on('change', majSurface);
                            $('#colis_id').on('change', majSurface);

                        })
                        function majSurface(e){
                            var produits = {<?php foreach ($produits as $produit) echo '"'.$produit->id.'":'.(($produit->largeur>0?$produit->largeur:0) / 1000).','; ?>};
                            var colis = {<?php foreach ($coliss as $colis) echo '"'.$colis->id.'":'.($colis->longueur / 1000).','; ?>};
                            if( !isNaN( $('#nombre_colis').val() ) && ( $('#colis_id').val() != '') && ( $('#produit_id').val() != '') ) {
                                var res = colis[$('#colis_id').val()] * $('#nombre_colis').val() * produits[$('#produit_id').val()] * 10;
                                $("#infosurface").html("! Les colis font : " + res.toFixed(3) + " m<sup>2</sup>");
                            } else {
                                $("#infosurface").html("");
                            }
                        }
                    </script>
                </form>
            </div>
        </div>
    </div>
</div>
    
@endsection
