@extends('produits.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                    Modifier un Produit et son Inventaire associé.
                </div>
                <div class="float-end">
                    <a href="{{ route('produits.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('produits.updateplus', $produit->id) }}" method="post">
                    
                    @csrf
                    @method("PUT")
                    <div class="card">
                        <div class="card-header">
                            <div class="float-start">Le produit</div>
                        </div>
                        <div class="card-body">
                            @if(null != $produit->alternatif || '' != $produit->alternatif)
                            <div class="mb-3 row">
                                <label for="alternatif" class="col-md-4 col-form-label text-md-end text-start">Descriptif alternatif</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control @error('alternatif') is-invalid @enderror" id="alternatif" name="alternatif" value="{{ $produit->alternatif }}">
                                    @if ($errors->has('alternatif'))
                                        <span class="text-danger">{{ $errors->first('alternatif') }}</span>
                                    @endif
                                </div>
                            </div>
                            @endif

                            <div class="mb-3 row">
                                <label for="referenceA" class="col-md-4 col-form-label text-md-end text-start">Référence</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control @error('referenceA') is-invalid @enderror" id="referenceA" name="referenceA" value="{{ $produit->referenceA }}">
                                    @if ($errors->has('referenceA'))
                                        <span class="text-danger">{{ $errors->first('referenceA') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="referenceB" class="col-md-4 col-form-label text-md-end text-start">Référence Bis</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control @error('referenceB') is-invalid @enderror" id="referenceB" name="referenceB" value="{{ $produit->referenceB }}">
                                    @if ($errors->has('referenceB'))
                                        <span class="text-danger">{{ $errors->first('referenceB') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="site" class="col-md-4 col-form-label text-md-end text-start">Site</label>
                                <div class="col-md-6">
                                    <select class="form-control @error('name') is-invalid @enderror" name="site">
                                        <option value="Loubejac" @if ($produit->site == 'Loubejac') selected="selected" @endif>Loubejac</option>
                                        <option value="Briolance" @if ($produit->site == 'Briolance') selected="selected" @endif>Briolance</option>
                                    </select>
                                    @if ($errors->has('site'))
                                        <span class="text-danger">{{ $errors->first('site') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="famille" class="col-md-4 col-form-label text-md-end text-start">Famille</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control @error('famille') is-invalid @enderror" id="famille" name="famille" value="{{ $produit->famille }}">
                                    @if ($errors->has('famille'))
                                        <span class="text-danger">{{ $errors->first('famille') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="type" class="col-md-4 col-form-label text-md-end text-start">Type</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control @error('type') is-invalid @enderror" id="type" name="type" value="{{ $produit->type }}">
                                    @if ($errors->has('type'))
                                        <span class="text-danger">{{ $errors->first('type') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="essence" class="col-md-4 col-form-label text-md-end text-start">Essence</label>
                                <div class="col-md-6">
                                    <select class="form-control @error('essence') is-invalid @enderror" name="essence">
                                        <option value="--N/A--" @if ($produit->essence == '--N/A--') selected="selected" @endif>--N/A--</option>
                                        @foreach ($lesessences as $unessence)
                                        <option value="{{$unessence->titre}}" @if ($produit->essence == $unessence->titre) selected="selected" @endif>{{ $unessence->titre }}</option>  
                                        @endforeach
                                    </select>
                                    @if ($errors->has('essence'))
                                        <span class="text-danger">{{ $errors->first('essence') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="qualite" class="col-md-4 col-form-label text-md-end text-start">Qualité</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control @error('qualite') is-invalid @enderror" id="qualite" name="qualite" value="{{ $produit->qualite }}">
                                    @if ($errors->has('qualite'))
                                        <span class="text-danger">{{ $errors->first('qualite') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité de vente</label>
                                <div class="col-md-6">
                                    <select class="form-control @error('unite') is-invalid @enderror" name="unite">
                                        @foreach(App\Models\Produit::$unitesDeVentes as $code => $codeDetail)
                                        <option value="{{$code}}" @if ($produit->unite == $code) selected="selected" @endif><?=$codeDetail['html']?></option>  
                                        @endforeach
                                    </select>
                                    @if ($errors->has('unite'))
                                        <span class="text-danger">{{ $errors->first('unite') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="epaisseur" class="col-md-4 col-form-label text-md-end text-start">Epaisseur (en mm)</label>
                                <div class="col-md-6">
                                <input type="number" class="form-control @error('epaisseur') is-invalid @enderror" id="epaisseur" name="epaisseur" value="{{ $produit->epaisseur ?? 0}}">
                                    @if ($errors->has('epaisseur'))
                                        <span class="text-danger">{{ $errors->first('epaisseur') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="largeur" class="col-md-4 col-form-label text-md-end text-start">Largeur (en mm)</label>
                                <div class="col-md-6">
                                <input type="number" class="form-control @error('largeur') is-invalid @enderror" id="largeur" name="largeur" value="{{ $produit->largeur}}">
                                    @if ($errors->has('largeur'))
                                        <span class="text-danger">{{ $errors->first('largeur') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="longueur" class="col-md-4 col-form-label text-md-end text-start">Longueur (en mm)</label>
                                <div class="col-md-6">
                                <input type="number" class="form-control @error('longueur') is-invalid @enderror" id="longueur" name="longueur" value="{{ $produit->longueur }}">
                                    @if ($errors->has('longueur'))
                                        <span class="text-danger">{{ $errors->first('longueur') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="humidite" class="col-md-4 col-form-label text-md-end text-start">Humiditée</label>
                                <div class="col-md-6">
                                    <select class="form-control @error('humidite') is-invalid @enderror" name="humidite">
                                        <option value="0" @if ($produit->humidite == 0) selected="selected" @endif>--N/A--</option>
                                        <option value="12" @if ($produit->humidite == 12) selected="selected" @endif>Sec</option>
                                        <option value="50" @if ($produit->humidite == 50) selected="selected" @endif>Ressuyé</option>
                                        <option value="100" @if ($produit->humidite == 100) selected="selected" @endif>Vert</option>
                                    </select>
                                    @if ($errors->has('humidite'))
                                        <span class="text-danger">{{ $errors->first('humidite') }}</span>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <label for="origine" class="col-md-4 col-form-label text-md-end text-start">Origine</label>
                                <div class="col-md-6">
                                    <select class="form-control @error('origine') is-invalid @enderror" name="origine">
                                        <option value="Production" @if ($produit->origine == 'Production') selected="selected" @endif>Production</option>
                                        <option value="Negoce" @if ($produit->origine == 'Negoce') selected="selected" @endif>Negoce</option>
                                        <option value="Intermédiaire" @if ($produit->origine == 'Intermédiaire') selected="selected" @endif>Stock Intermédiaire</option>
                                        <option value="Ressources" @if ($produit->origine == 'Ressources') selected="selected" @endif>Ressources</option>
                                        <option value="Destockage" @if ($produit->origine == 'Destockage') selected="selected" @endif>Destockage</option>
                                    </select>
                                    @if ($errors->has('origine'))
                                        <span class="text-danger">{{ $errors->first('origine') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="analytiqueA" class="col-md-4 col-form-label text-md-end text-start">Code Famille</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control @error('analytiqueA') is-invalid @enderror" id="analytiqueA" name="analytiqueA" value="{{ $produit->analytiqueA }}">
                                    @if ($errors->has('analytiqueA'))
                                        <span class="text-danger">{{ $errors->first('analytiqueA') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="analytiqueB" class="col-md-4 col-form-label text-md-end text-start">Code de Production</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control @error('analytiqueB') is-invalid @enderror" id="analytiqueB" name="analytiqueB" value="{{ $produit->analytiqueB }}">
                                    @if ($errors->has('analytiqueB'))
                                        <span class="text-danger">{{ $errors->first('analytiqueB') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="analytiqueC" class="col-md-4 col-form-label text-md-end text-start">Code Analytique C</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control @error('analytiqueC') is-invalid @enderror" id="analytiqueC" name="analytiqueC" value="{{ $produit->analytiqueC }}">
                                    @if ($errors->has('analytiqueC'))
                                        <span class="text-danger">{{ $errors->first('analytiqueC') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="card">
                        <div class="card-header">
                            <div class="float-start">L'Inventaire au 31/12/2023</div>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité en inventaire</label>
                                <div class="col-md-6">
                                <input type="number" class="form-control"  id="quantite" name="quantite" value="{{$inventaire->quantite}}" required>
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="localisation" class="col-md-4 col-form-label text-md-end text-start">Localisation</label>
                                <div class="col-md-6">
                                <input type="text" class="form-control" id="localisation" name="localisation" value="{{$inventaire->localisation}}">
                                </div>
                            </div>
                        </div>
                    </div>




                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Mettre a jour le Produit">
                    </div>
                    
                </form>
            </div>
        </div>
    </div>    
</div>
    
@endsection
