@extends('commandes.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                    Modifier la Commande
                </div>
                <div class="float-end">
                    <a href="{{ route('commandes.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('commandes.update', $data->id) }}" method="post">
                    @csrf
                    @method("PUT")

                    <div class="mb-3 row">
                        <label for="date_commande" class="col-md-4 col-form-label text-md-end text-start">Date</label>
                        <div class="col-md-6">
                          <input type="date" class="form-control @error('date_commande') is-invalid @enderror" id="date_commande" name="date_commande" value="{{ $data->date_commande }}">
                            @if ($errors->has('date_commande'))
                                <span class="text-danger">{{ $errors->first('date_commande') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="client_id" class="col-md-4 col-form-label text-md-end text-start">Le Client</label>
                        <div class="col-md-6">{{ $data->client()->first()->nom.' - ' .$data->client()->first()->email}}
                            <input type="hidden" name="client_id" value="{{ $data->client_id }}" />
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                        <div class="col-md-6">{{ $data->produit()->first()->referenceA.' - ' }}@if(null != $data->produit()->first()->alternatif || '' != $data->produit()->first()->alternatif) {{ $data->produit()->first()->alternatif }}@else {{ $data->produit()->first()->getDescriptifFull() }} @endif
                            <input type="hidden" name="produit_id" value="{{ $data->produit_id }}" />
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité commandée</label>
                        <div class="col-md-6">
                          <input type="number" class="form-control @error('quantite') is-invalid @enderror" id="quantite" name="quantite" value="{{ $data->quantite }}">
                            @if ($errors->has('quantite'))
                                <span class="text-danger">{{ $errors->first('quantite') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité</label>
                        <div class="col-md-6">
                            <select class="form-control @error('unite') is-invalid @enderror" name="unite">
                                <option value="m2" @if ($data->unite == 'm2') selected="selected" @endif>m2</option>
                                <option value="m3" @if ($data->unite == 'm3') selected="selected" @endif>m3</option>
                                <option value="rouleau" @if ($data->unite == 'rouleau') selected="selected" @endif>rouleau</option>
                            </select>
                            @if ($errors->has('unite'))
                                <span class="text-danger">{{ $errors->first('unite') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="date_annonce" class="col-md-4 col-form-label text-md-end text-start">Date Annoncée</label>
                        <div class="col-md-6">
                          <input type="date" class="form-control @error('date_annonce') is-invalid @enderror" id="date_annonce" name="date_annonce" value="{{ $data->date_annonce }}">
                            @if ($errors->has('date_annonce'))
                                <span class="text-danger">{{ $errors->first('date_annonce') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="observations" class="col-md-4 col-form-label text-md-end text-start">Observations</label>
                        <div class="col-md-6">
                          <textarea class="form-control @error('observations') is-invalid @enderror" id="observations" name="observations"> {{ $data->observations }}</textarea>
                            @if ($errors->has('observations'))
                                <span class="text-danger">{{ $errors->first('observations') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="statut" class="col-md-4 col-form-label text-md-end text-start">Statut</label>
                        <div class="col-md-6">
                            <select class="form-control @error('statut') is-invalid @enderror" name="statut">
                            <option value="encours" @if ($data->statut == 'encours') selected="selected" @endif>En Cours</option>
                            <option value="expedie" @if ($data->statut == 'expedie') selected="selected" @endif>Expédiée</option>
                            <option value="cloturee" @if ($data->statut == 'cloturee') selected="selected" @endif>Cloturée</option>
                            <option value="annule" @if ($data->statut == 'annule') selected="selected" @endif>Annulée</option>
                            </select>
                            @if ($errors->has('statut'))
                                <span class="text-danger">{{ $errors->first('statut') }}</span>
                            @endif
                        </div>
                    </div>
                   <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Mettre à jour la Commande">
                    </div>
                    
                </form>
            </div>
        </div>
    </div>    
</div>
    
@endsection
