@extends('commandes.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                    Renseigner une commande
                </div>
                <div class="float-end">
                    <a href="{{ route('commandes.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('commandes.store') }}" method="post">
                    @csrf

                    <div class="mb-3 row">
                        <label for="date_commande" class="col-md-4 col-form-label text-md-end text-start">Date</label>
                        <div class="col-md-6">
                          <input type="date" class="form-control @error('date_commande') is-invalid @enderror" id="date_commande" name="date_commande" value="{{ old('date_commande') ?? date('Y-m-d') }}">
                            @if ($errors->has('date_commande'))
                                <span class="text-danger">{{ $errors->first('date_commande') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="client_id" class="col-md-4 col-form-label text-md-end text-start">Le Client</label>
                        <div class="col-md-6">
                            <select class="form-control @error('produit_id') is-invalid @enderror select2" name="client_id">
                                @foreach ($clients as $client)
                                <option value="{{$client->id}}" @if (old('client_id') == $client->id) selected="selected" @endif>{{ $client->nom.' - ' . $client->email}}</option>  
                                @endforeach
                            </select>
                            @if ($errors->has('client_id'))
                                <span class="text-danger">{{ $errors->first('client_id') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                        <div class="col-md-6">
                            <select class="form-control @error('produit_id') is-invalid @enderror select2" name="produit_id">
                                @foreach ($produits as $produit)
                                <option value="{{$produit->id}}" @if (old('produit_id') == $produit->id) selected="selected" @endif>{{ $produit->referenceA.' - ' }}@if(null != $produit->alternatif || '' != $produit->alternatif) {{ $produit->alternatif }}@else {{ $produit->getDescriptifFull() }} @endif</option>  
                                @endforeach
                            </select>
                            @if ($errors->has('produit_id'))
                                <span class="text-danger">{{ $errors->first('produit_id') }}</span>
                            @endif
                        </div>
                    </div>

                    <script type="text/javascript" >
                            $(document).ready(function() {
                                $('.select2').select2();
                            })
                    </script>


                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité commandée</label>
                        <div class="col-md-6">
                          <input type="number" class="form-control @error('quantite') is-invalid @enderror" id="quantite" name="quantite" value="{{ old('quantite') }}">
                            @if ($errors->has('quantite'))
                                <span class="text-danger">{{ $errors->first('quantite') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité</label>
                        <div class="col-md-6">
                            <select class="form-control @error('unite') is-invalid @enderror" name="unite">
                                <option value="m2" @if (old('unite') == 'm2') selected="selected" @endif>m<sup>2</sup></option>
                                <option value="m3" @if (old('unite') == 'm3') selected="selected" @endif>m3</option>
                                <option value="Stère" @if (old('unite') == 'Stère') selected="selected" @endif>Stère</option>
                                <option value="Pile" @if (old('unite') == 'Pile') selected="selected" @endif>Pile</option>
                                <option value="ml" @if (old('unite') == 'ml') selected="selected" @endif>ml</option>
                                <option value="Pièce" @if (old('unite') == 'Pièce') selected="selected" @endif>Pièce</option>
                                <option value="Kilo" @if (old('unite') == 'Kilo') selected="selected" @endif>Kilo</option>
                                <option value="Rouleau" @if (old('unite') == 'rouleau') selected="selected" @endif>Rouleau</option>
                                <option value="Palette" @if (old('unite') == 'Palette') selected="selected" @endif>Palette</option>
                            </select>
                            @if ($errors->has('unite'))
                                <span class="text-danger">{{ $errors->first('unite') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="date_annonce" class="col-md-4 col-form-label text-md-end text-start">Date Annoncée</label>
                        <div class="col-md-6">
                          <input type="date" class="form-control @error('date_annonce') is-invalid @enderror" id="date_annonce" name="date_annonce" value="{{ old('date_annonce') }}">
                            @if ($errors->has('date_annonce'))
                                <span class="text-danger">{{ $errors->first('date_annonce') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="observations" class="col-md-4 col-form-label text-md-end text-start">Observations</label>
                        <div class="col-md-6">
                          <textarea class="form-control @error('observations') is-invalid @enderror" id="observations" name="observations"> {{ old('observations') }}</textarea>
                            @if ($errors->has('observations'))
                                <span class="text-danger">{{ $errors->first('observations') }}</span>
                            @endif
                        </div>
                    </div>

                    
                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Valider la Commande">
                    </div>
                    
                </form>
            </div>
        </div>
    </div>
</div>
    
@endsection
