@extends('clients.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                    Ajouter un nouveau Client
                </div>
                <div class="float-end">
                    <a href="{{ route('clients.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('clients.store') }}" method="post">
                    @csrf


                    <div class="mb-3 row">
                        <label for="code_client" class="col-md-4 col-form-label text-md-end text-start">Code Client</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('code_client') is-invalid @enderror" id="code_client" name="code_client" value="{{ old('code_client') }}">
                            @if ($errors->has('code_client'))
                                <span class="text-danger">{{ $errors->first('code_client') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="raison_sociale" class="col-md-4 col-form-label text-md-end text-start">Raison Sociale</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('raison_sociale') is-invalid @enderror" id="raison_sociale" name="raison_sociale" value="{{ old('raison_sociale') }}">
                            @if ($errors->has('raison_sociale'))
                                <span class="text-danger">{{ $errors->first('raison_sociale') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="nom" class="col-md-4 col-form-label text-md-end text-start">Nom</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('nom') is-invalid @enderror" id="nom" name="nom" value="{{ old('nom') }}">
                            @if ($errors->has('nom'))
                                <span class="text-danger">{{ $errors->first('nom') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="email" class="col-md-4 col-form-label text-md-end text-start">Email</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email') }}">
                            @if ($errors->has('email'))
                                <span class="text-danger">{{ $errors->first('email') }}</span>
                            @endif
                        </div>
                    </div>


                    <div class="mb-3 row">
                        <label for="telephone" class="col-md-4 col-form-label text-md-end text-start">Téléphone</label>
                        <div class="col-md-6">
                          <input type="tel" class="form-control @error('telephone') is-invalid @enderror" id="telephone" name="telephone" value="{{ old('telephone') }}">
                            @if ($errors->has('telephone'))
                                <span class="text-danger">{{ $errors->first('telephone') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="adresse" class="col-md-4 col-form-label text-md-end text-start">Adresse</label>
                        <div class="col-md-6">
                          <textarea class="form-control @error('adresse') is-invalid @enderror" id="adresse" name="adresse">{{ old('adresse') }}</textarea>
                            @if ($errors->has('adresse'))
                                <span class="text-danger">{{ $errors->first('adresse') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                    <label for="cp" class="col-md-4 col-form-label text-md-end text-start">Code Postal</label>
                    <div class="col-md-6">
                        <input type="text" class="form-control @error('cp') is-invalid @enderror" id="cp" name="cp" value="{{ old('cp') }}">
                            @if ($errors->has('cp'))
                                <span class="text-danger">{{ $errors->first('cp') }}</span>
                            @endif
                    </div>
                    </div>

                    <div class="mb-3 row">
                    <label for="ville" class="col-md-4 col-form-label text-md-end text-start">Ville</label>
                    <div class="col-md-6">
                        <input type="text" class="form-control @error('ville') is-invalid @enderror" id="ville" name="ville" value="{{ old('ville') }}">
                            @if ($errors->has('ville'))
                                <span class="text-danger">{{ $errors->first('ville') }}</span>
                            @endif
                    </div>
                    </div>

                    <div class="mb-3 row">
                    <label for="siret" class="col-md-4 col-form-label text-md-end text-start">Siret</label>
                    <div class="col-md-6">
                        <input type="text" class="form-control @error('siret') is-invalid @enderror" id="siret" name="siret" value="{{ old('siret') }}">
                            @if ($errors->has('siret'))
                                <span class="text-danger">{{ $errors->first('siret') }}</span>
                            @endif
                    </div>
                    </div>

                    <div class="mb-3 row">
                    <label for="contact" class="col-md-4 col-form-label text-md-end text-start">Contact</label>
                    <div class="col-md-6">
                        <input type="text" class="form-control @error('contact') is-invalid @enderror" id="contact" name="contact" value="{{ old('contact') }}">
                            @if ($errors->has('contact'))
                                <span class="text-danger">{{ $errors->first('contact') }}</span>
                            @endif
                    </div>
                    </div>

                    <div class="mb-3 row">
                    <label for="mobile" class="col-md-4 col-form-label text-md-end text-start">Mobile</label>
                    <div class="col-md-6">
                        <input type="tel" class="form-control @error('mobile') is-invalid @enderror" id="mobile" name="mobile" value="{{ old('mobile') }}">
                            @if ($errors->has('mobile'))
                                <span class="text-danger">{{ $errors->first('mobile') }}</span>
                            @endif
                    </div>
                    </div>

                    

                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Ajouter le Client">
                    </div>
                    
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
