<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Produit;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create('tarifs', function (Blueprint $table) {
            $table->id();
            $table->date('date_debut')->default(DB::raw('NOW()'));
            $table->date('date_fin')->default(DB::raw('NOW()'));
            $table->foreignIdFor(Produit::class);
            $table->decimal('prix_revient', 8, 3);
            $table->decimal('prix_negociant', 8, 3)->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists('tarifs');
    }
};
