<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRoleMiddleware
{
    public function handle($request, Closure $next, ...$roles)
    {
        // Vérifie si l'utilisateur est connecté
        if (Auth::check()) {
            // Récupère le rôle de l'utilisateur actuel
            $userRole = Auth::user()->role->name;

            // Vérifie si le rôle de l'utilisateur correspond à l'un des rôles spécifiés dans la route
            if (in_array($userRole, $roles)) {
                return $next($request);
            }
        }

        // Redirige l'utilisateur vers une page non autorisée s'il ne correspond pas au rôle
        return redirect('/unauthorized');
    }
}
