<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreCommandeRequest;
use App\Http\Requests\UpdateCommandeRequest;
use App\Models\Commande;
use App\Models\Produit;
use App\Models\Client;

class CommandeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(){
        return view('commandes.index', ['datas' => Commande::sortable()->paginate(30) ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create() {
        return view('commandes.create', [
            'produits' => Produit::all(),
            'clients' => Client::all()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCommandeRequest $request) {
        Commande::create($request->all());
	    return redirect()->route('commandes.index')
                ->withSuccess('Nouvelle Commande ajoutée avec succes.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Commande $commande)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Commande $commande) {
        return view('commandes.edit', [
            'data' => $commande,
            'produit' => Produit::find($commande->produit_id),
            'client' => Client::find($commande->client_id)
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateCommandeRequest $request, Commande $commande) {
        $commande->update( $request->all() );
        return redirect()->route('commandes.index')
                ->withSuccess('La Commande a été mis à jours correctement.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Commande $commande) {
        $commande->delete();
        return redirect()->route('commandes.index')
                ->withSuccess('La Commande a été correctement supprimée.');
    }
}
