<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreClientRequest;
use App\Http\Requests\UpdateClientRequest;
use App\Models\Client;

class ClientController extends Controller {
    /**
     * Display a listing of the resource.
     */
    public function index() {
        return view('clients.index', ['datas' => Client::sortable()->paginate(30) ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create() {
        return view('clients.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreClientRequest $request) {
        try {
            Client::create($request->all());
            return redirect()->route('clients.index')->withSuccess('Nouveau Client ajouté avec succès.');
        } catch (\Exception $e) {
            return back()->withErrors(['error' => $e->getMessage()])->withInput();
        }
    }
    
    /**
     * Display the specified resource.
     */
    public function show(Client $client) {
        return view('clients.show', [ 'data' => $client ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Client $client) {
        return view('clients.edit', [
            'data' => $client
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateClientRequest $request, Client $client) {
        $client->update( $request->all() );
        return redirect()->route('clients.index')
                ->withSuccess('Le Client a été mis à jours correctement.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Client $client) {
        $client->delete();
        return redirect()->route('clients.index')
                ->withSuccess('Le Client a été correctement supprimé.');
    }
}
