<?php $__env->startSection('content'); ?>

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                Ajouter un mouvement au stock
                </div>
                <div class="float-end">
                    <a href="<?php echo e(route('stocks.index')); ?>" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('stocks.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="mb-3 row">
                        <label for="date_mouvement" class="col-md-4 col-form-label text-md-end text-start">Date</label>
                        <div class="col-md-6">
                          <input type="date" class="form-control <?php $__errorArgs = ['date_mouvement'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="date_mouvement" name="date_mouvement" value="<?php echo e(old('date_mouvement') ?? date('Y-m-d')); ?>">
                            <?php if($errors->has('date_mouvement')): ?>
                                <span class="text-danger"><?php echo e($errors->first('date_mouvement')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['produit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="produit_id" id="produit_id">
                                <?php $__currentLoopData = $produits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($produit->id); ?>" <?php if(old('produit_id') == $produit->id): ?> selected="selected" <?php endif; ?>><?php echo e($produit->referenceA . ' - ' . $produit->getDescriptifFullOrAlter()); ?></option>  
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('produit_id')): ?>
                                <span class="text-danger"><?php echo e($errors->first('produit_id')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité à ajouter (en +) à retirer (en -) </label>
                        <div class="col-md-6">
                          <input type="number" class="form-control <?php $__errorArgs = ['quantite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="quantite" name="quantite" value="<?php echo e(old('quantite')); ?>" step="any">
                          <span id="infosurface" class="badge badge-primary badge-pill text-primary"></span>
                            <?php if($errors->has('quantite')): ?>
                                <span class="text-danger"><?php echo e($errors->first('quantite')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité de vente</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['unite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="unite">
                                <option value="m2" <?php if(old('unite') == 'm2'): ?> selected="selected" <?php endif; ?>>m<sup>2</sup></option>
                                <option value="m3" <?php if(old('unite') == 'm3'): ?> selected="selected" <?php endif; ?>>m3</option>
                                <option value="Stère" <?php if(old('unite') == 'Stère'): ?> selected="selected" <?php endif; ?>>Stère</option>
                                <option value="Pile" <?php if(old('unite') == 'Pile'): ?> selected="selected" <?php endif; ?>>Pile</option>
                                <option value="ml" <?php if(old('unite') == 'ml'): ?> selected="selected" <?php endif; ?>>ml</option>
                                <option value="Pièce" <?php if(old('unite') == 'Pièce'): ?> selected="selected" <?php endif; ?>>Pièce</option>
                                <option value="Kilo" <?php if(old('unite') == 'Kilo'): ?> selected="selected" <?php endif; ?>>Kilo</option>
                                <option value="Rouleau" <?php if(old('unite') == 'rouleau'): ?> selected="selected" <?php endif; ?>>Rouleau</option>
                                <option value="Palette" <?php if(old('unite') == 'Palette'): ?> selected="selected" <?php endif; ?>>Palette</option>
                            </select>
                            <?php if($errors->has('unite')): ?>
                                <span class="text-danger"><?php echo e($errors->first('unite')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="mb-3 row">
                        <label for="motif" class="col-md-4 col-form-label text-md-end text-start">Motif</label>
                        <div class="col-md-6">
                            
                          <input type="text" class="form-control <?php $__errorArgs = ['motif'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="motif" name="motif" value="<?php echo e(old('motif')); ?>">                            
                            <?php if($errors->has('motif')): ?>
                                <span class="text-danger"><?php echo e($errors->first('motif')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            Colissage (pour nos Parquets)
                        </div>
                        <div class="card-body">
                            <div class="mb-3 row">
                                <label for="colis_id" class="col-md-4 col-form-label text-md-end text-start">Le Colissage</label>
                                <div class="col-md-6">
                                    <select class="form-control <?php $__errorArgs = ['colis_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="colis_id" id="colis_id">
                                        <option value="" <?php if(old('colis_id') == ''): ?> selected="selected" <?php endif; ?>>Sans Objet</option>  
                                        <?php $__currentLoopData = $coliss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($colis->id); ?>" <?php if(old('colis_id') == $colis->id): ?> selected="selected" <?php endif; ?>><?php echo e($colis->getDescriptifFull()); ?></option>  
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php if($errors->has('colis_id')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('colis_id')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="nombre_colis" class="col-md-4 col-form-label text-md-end text-start">Nombre de colis</label>
                                <div class="col-md-6">
                                    <input type="number" class="form-control <?php $__errorArgs = ['nombre_colis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="nombre_colis" name="nombre_colis" value="<?php echo e(old('nombre_colis')); ?>">
                                    <?php if($errors->has('nombre_colis')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('nombre_colis')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Valider le Mouvement">
                    </div>
                    <script type="text/javascript" >
                        $(document).ready(function() {
                            $('.select2').select2();
  
                            if($('#colis_id').val() == '') {
                                $('#nombre_colis').attr('disabled', true);
                            } 

                            $('#colis_id').on('select2:selecting', function(e) {
                                //console.log('Selecting: ' , e.params.args.data);
                                if(e.params.args.data.id == '') {
                                    $('#nombre_colis').val('');
                                    $('#nombre_colis').attr('disabled', true);
                                } else {
                                    $('#nombre_colis').attr('disabled', false);
                                    majSurface(e);
                                    //$("#infosurface").html("! Les colis font : " + 127 + "m<sup>2</sup>");
                                    //$("#quantite").prop("readonly", true);
                                }
                            });

                            $('#nombre_colis').on('keyup', majSurface);
                            $('#nombre_colis').on('change', majSurface);
                            $('#colis_id').on('change', majSurface);

                        })
                        function majSurface(e){
                            var produits = {<?php foreach ($produits as $produit) echo '"'.$produit->id.'":'.(($produit->largeur>0?$produit->largeur:0) / 1000).','; ?>};
                            var colis = {<?php foreach ($coliss as $colis) echo '"'.$colis->id.'":'.($colis->longueur / 1000).','; ?>};
                            if( !isNaN( $('#nombre_colis').val() ) && ( $('#colis_id').val() != '') && ( $('#produit_id').val() != '') ) {
                                var res = colis[$('#colis_id').val()] * $('#nombre_colis').val() * produits[$('#produit_id').val()] * 10;
                                $("#infosurface").html("! Les colis font : " + res.toFixed(3) + " m<sup>2</sup>");
                            } else {
                                $("#infosurface").html("");
                            }
                        }
                    </script>
                </form>
            </div>
        </div>
    </div>
</div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('stocks.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/DevIntranetFontenoyBois/resources/views/stocks/create.blade.php ENDPATH**/ ?>