<?php $__env->startSection('content'); ?>

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success" role="alert">
                <?php echo e($message); ?>

            </div>
        <?php endif; ?>

        <?php for($i = 0; $i <= 30; $i++): ?>
            <?php
                $currentDate = now()->subDays($i)->toDateString();
            
            ?>
            <?php if( (strftime('%A', strtotime($currentDate)) != 'samedi') && (strftime('%A', strtotime($currentDate)) != 'dimanche')): ?>
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
			<div class="text-center">
                        Production du <?php echo e(strftime('%A', strtotime($currentDate))); ?> <?php echo e(strftime('%d %B %Y', strtotime($currentDate))); ?>

                        </div>

                        <div class="text-end">
                        <a href="<?php echo e(route('gestions.create', ['date' => $currentDate])); ?>" class="btn btn-success btn-sm">Modifier la production</a>

                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">Produit</th>
                                <th scope="col">Quantité</th>
                                <th scope="col">Unité</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $stock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produitStock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                           
                            <?php if($produitStock->date_mouvement->format('Y-m-d')==$currentDate): ?>   
                            <tr>
                                    <td><?php echo e($produitStock->produit->getDescriptifFullOrAlter()); ?></td>
                                    <td><?php echo e($produitStock->quantite *1); ?></td>
                                    <td><?php echo e($produitStock->unite); ?></td>
                                    <td></td>
                                </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <br>
            <?php endif; ?>
        <?php endfor; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('gestions.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/IntranetFontenoyBois/resources/views/gestions/index.blade.php ENDPATH**/ ?>