@extends('stocks.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif

        <div class="card">
            <div class="card-header">Etat des stocks : vue détaillée avec tous les mouvements</div>
            <div class="card-body">
                <a href="{{ route('stocks.create') }}" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter un mouvement de stock</a>
                <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th scope="col">@sortablelink('produit.referenceA', 'Ref')</th>
                        <th scope="col">@sortablelink('produit.famille', 'Famille')</th>
                        <th scope="col">@sortablelink('produit.type', 'Type')</th>
                        <th scope="col">@sortablelink('produit.essence', 'Essence')</th>
                        <th scope="col">@sortablelink('produit.qualite', 'Qualité')</th>
                        <th scope="col">Epaisseur</th>
                        <th scope="col">Largeur</th>
                        <th scope="col">Longueur</th>
                        <th scope="col">Humidité</th>
                        <th scope="col">@sortablelink('origine', 'Origine')</th>
                        <th scope="col">Date</th>
                        <th scope="col">Quantité</th>
                        <th scope="col">Colissage</th>
                        <th scope="col">Motif</th>
                        <th scope="col">Action</th>
                     </tr>
                    </thead>
                    <tbody>
                        @forelse ($datas as $data)
                        <?php $produit = $data->produit()->first(); ?>
                        <tr class="@if($data->quantite>=0) table-success @else table-danger @endif">
                            <td>{{ $produit->referenceA }}</td>
                            @if(null == $produit->alternatif || '' == $produit->alternatif)
                            <td>{{ $produit->famille }}</td>
                            <td>{{ $produit->type }}</td>
                            <td>{{ $produit->essence }}</td>
                            <td>{{ $produit->qualite }}</td>
                            <td>@if($produit->epaisseur>0) {{ $produit->epaisseur }} @else &nbsp; @endif</td>
                            <td>@if($produit->largeur>0) {{ $produit->largeur }} @else &nbsp; @endif</td>
                            <td>@if($produit->longueur>0) {{ $produit->longueur }} @else &nbsp; @endif</td>
                            <td>{{ $produit->humiditeLabel() }}</td>
                            <td>{{ $produit->origine }}</td>
                            @else
                            <td colspan="9">{{ $produit->alternatif }}</td>
                            @endif
                            <td>{{ $data->date_mouvement->format('d-m-Y') }}</td>
                            <td>{{ $data->quantite }}&nbsp;{{ $data->unite }}</td>
                            <td>
                                @if($data->colis()->first())
                                    {{ $data->nombre_colis .' ' .$data->colis()->first()->getDescriptifLight() }}
                                @else
                                    &nbsp;
                                @endif
                            </td>
                            <td>{{ $data->motif }}</td>
                            <td>
                                <form action="{{ route('stocks.destroy', $data->id) }}" method="post">
                                    @csrf
                                    @method('DELETE')

                                    <!-- <a href="{{ route('stocks.show', $data->id) }}" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a> -->
                                    <!-- <a href="{{ route('stocks.show', $data->id) }}" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a> -->

                                    <!-- <a href="{{ route('stocks.edit', $data->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif</a> -->

                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer ce Mouvement de Stock (Irreversible) ?');"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                       </tr>
                        @empty
                            <td colspan="13">
                                <span class="text-danger">
                                    <strong>Aucun inventaire!</strong>
                                </span>
                            </td>
                        @endforelse

                    </tbody>
                  </table>

                  {{  $datas->withQueryString()->links() }}

            </div>
        </div>
    </div>    
</div>
    
@endsection
