@extends('produits.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start">
                    Ajouter un nouveau Produit
                </div>
                <div class="float-end">
                    <a href="{{ route('produits.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('produits.store') }}" method="post">
                    @csrf

                    <div class="mb-3 row">
                        <label for="referenceA" class="col-md-4 col-form-label text-md-end text-start">Référence</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('referenceA') is-invalid @enderror" id="referenceA" name="referenceA" value="{{ old('referenceA') }}">
                            @if ($errors->has('referenceA'))
                                <span class="text-danger">{{ $errors->first('referenceA') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="referenceB" class="col-md-4 col-form-label text-md-end text-start">Référence Bis</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('referenceB') is-invalid @enderror" id="referenceB" name="referenceB" value="{{ old('referenceB') }}">
                            @if ($errors->has('referenceB'))
                                <span class="text-danger">{{ $errors->first('referenceB') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="site" class="col-md-4 col-form-label text-md-end text-start">Site</label>
                        <div class="col-md-6">
                            <select class="form-control @error('name') is-invalid @enderror" name="site">
                                <option value="Loubejac" @if (old('site') == 'Loubejac') selected="selected" @endif>Loubejac</option>
                                <option value="Briolance" @if (old('site') == 'Briolance') selected="selected" @endif>Briolance</option>
                            </select>
                            @if ($errors->has('site'))
                                <span class="text-danger">{{ $errors->first('site') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="famille" class="col-md-4 col-form-label text-md-end text-start">Famille</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('famille') is-invalid @enderror" id="famille" name="famille" value="{{ old('famille') }}">
                            @if ($errors->has('famille'))
                                <span class="text-danger">{{ $errors->first('famille') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="type" class="col-md-4 col-form-label text-md-end text-start">Type</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('type') is-invalid @enderror" id="type" name="type" value="{{ old('type') }}">
                            @if ($errors->has('type'))
                                <span class="text-danger">{{ $errors->first('type') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="essence" class="col-md-4 col-form-label text-md-end text-start">Essence</label>
                        <div class="col-md-6">
                            <select class="form-control @error('essence') is-invalid @enderror" name="essence">
                                <option value="--N/A--" @if (old('essence') == '--N/A--') selected="selected" @endif>--N/A--</option>
                                @foreach ($lesessences as $unessence)
                                <option value="{{$unessence->titre}}" @if (old('essence') == $unessence->titre) selected="selected" @endif>{{ $unessence->titre }}</option>  
                                @endforeach
                            </select>
                            @if ($errors->has('essence'))
                                <span class="text-danger">{{ $errors->first('essence') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="qualite" class="col-md-4 col-form-label text-md-end text-start">Qualité</label>
                        <div class="col-md-6">
                          <input type="text" class="form-control @error('qualite') is-invalid @enderror" id="qualite" name="qualite" value="{{ old('qualite') }}">
                            @if ($errors->has('qualite'))
                                <span class="text-danger">{{ $errors->first('qualite') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité de vente</label>
                        <div class="col-md-6">
                            <select class="form-control @error('unite') is-invalid @enderror" name="unite">
                                @foreach(App\Models\Produit::$unitesDeVentes as $code => $codeDetail)
                                <option value="{{$code}}" @if (old('unite') == $code) selected="selected" @endif><?=$codeDetail['html']?></option>  
                                @endforeach
                            </select>
                            @if ($errors->has('unite'))
                                <span class="text-danger">{{ $errors->first('unite') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="epaisseur" class="col-md-4 col-form-label text-md-end text-start">Epaisseur (en mm)</label>
                        <div class="col-md-6">
                          <input type="number" class="form-control @error('epaisseur') is-invalid @enderror" id="epaisseur" name="epaisseur" value="{{ old('epaisseur') ?? 0}}">
                            @if ($errors->has('epaisseur'))
                                <span class="text-danger">{{ $errors->first('epaisseur') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="largeur" class="col-md-4 col-form-label text-md-end text-start">Largeur (en mm)</label>
                        <div class="col-md-6">
                          <input type="number" class="form-control @error('largeur') is-invalid @enderror" id="largeur" name="largeur" value="{{ old('largeur') ?? 0}}">
                            @if ($errors->has('largeur'))
                                <span class="text-danger">{{ $errors->first('largeur') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="longueur" class="col-md-4 col-form-label text-md-end text-start">Longueur (en mm)</label>
                        <div class="col-md-6">
                          <input type="number" class="form-control @error('longueur') is-invalid @enderror" id="longueur" name="longueur" value="{{ old('longueur') ?? 0 }}">
                            @if ($errors->has('longueur'))
                                <span class="text-danger">{{ $errors->first('longueur') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="humidite" class="col-md-4 col-form-label text-md-end text-start">Humiditée</label>
                        <div class="col-md-6">
                            <select class="form-control @error('humidite') is-invalid @enderror" name="humidite">
                                <option value="0" @if (old('humidite') == '--N/A--') selected="selected" @endif>--N/A--</option>
                                <option value="12" @if (old('humidite') == 'Sec') selected="selected" @endif>Sec</option>
                                <option value="50" @if (old('humidite') == 'Ressuyé') selected="selected" @endif>Ressuyé</option>
                                <option value="100" @if (old('humidite') == 'Vert') selected="selected" @endif>Vert</option>
                            </select>
                            @if ($errors->has('humidite'))
                                <span class="text-danger">{{ $errors->first('humidite') }}</span>
                            @endif
                        </div>
                    </div>
                    
                    <div class="mb-3 row">
                        <label for="origine" class="col-md-4 col-form-label text-md-end text-start">Origine</label>
                        <div class="col-md-6">
                            <select class="form-control @error('origine') is-invalid @enderror" name="origine">
                                <option value="Production" @if (old('origine') == 'Production') selected="selected" @endif>Production</option>
                                <option value="Negoce" @if (old('origine') == 'Negoce') selected="selected" @endif>Negoce</option>
                                <option value="Intermédiaire" @if (old('origine') == 'Intermédiaire') selected="selected" @endif>Stock Intermédiaire</option>
                                <option value="Ressources" @if (old('origine') == 'Ressources') selected="selected" @endif>Ressources</option>
                                <option value="Destockage" @if (old('origine') == 'Destockage') selected="selected" @endif>Destockage</option>
                            </select>
                            @if ($errors->has('origine'))
                                <span class="text-danger">{{ $errors->first('origine') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-primary" value="Ajouter le Produit">
                    </div>
                    
                </form>
            </div>
        </div>
    </div>
</div>
    
@endsection
