@extends('commandes.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif

        <div class="card">
            <div class="card-header">Liste des commandes</div>
            <div class="card-body">
                <a href="{{ route('commandes.create') }}" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter une commande</a>
                <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th scope="col">S#</th>
                        <th scope="col">@sortablelink('date_commande', 'Date')</th>
                        <th scope="col">@sortablelink('client.nom', 'Client')</th>
                        <th scope="col">@sortablelink('produit.referenceA', 'Ref')</th>
                        <th scope="col">@sortablelink('produit.famille', 'Famille')</th>
                        <th scope="col">@sortablelink('produit.type', 'Type')</th>
                        <th scope="col">@sortablelink('origine', 'Origine')</th>
                        <th scope="col">Quantité</th>
                        <th scope="col">@sortablelink('date_annonce', 'Date Annoncée')</th>
                        <th scope="col">@sortablelink('statut', 'Statut')</th>
                        <th scope="col">Observations</th>
                        <th scope="col">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                        @forelse ($datas as $data)
                        <?php 
                            $produit = $data->produit()->first(); 
                            $client = $data->client()->first(); 
                            ?>
                        <tr>
                            <th scope="row">{{ $loop->iteration }}</th>
                            <td>{{ $data->date_commande }}</td>
                            <td>{{ $client->nom }}</td>
                            <td>{{ $produit->referenceA }}</td>
                            @if(null == $produit->alternatif || '' == $produit->alternatif)
                            <td>{{ $produit->famille }}</td>
                            <td>{{ $produit->type }}</td>
                            <td>{{ $produit->origine }}</td>
                            @else
                            <td colspan="3">{{ $produit->alternatif }}</td>
                            @endif
                            <td>{{ $data->quantite }}&nbsp;{{ $data->unite }}</td>
                            <td>{{ $data->date_annonce }}</td>
                            <td>{{ $data->statut }}</td>
                            <td>{{ $data->observations }}</td>
                            <td>
                                <form action="{{ route('commandes.destroy', $data->id) }}" method="post">
                                    @csrf
                                    @method('DELETE')

                                    <!-- <a href="{{ route('commandes.show', $data->id) }}" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a> -->
                                    <a href="{{ route('commandes.edit', $data->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif</a>

                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer cette Commande ?');"><i class="bi bi-trash"></i> Suppr</button>
                                </form>
                            </td>
                        </tr>
                        @empty
                            <td colspan="13">
                                <span class="text-danger">
                                    <strong>Aucune commande!</strong>
                                </span>
                            </td>
                        @endforelse
                    </tbody>
                  </table>

                  {{  $datas->withQueryString()->links() }}

            </div>
        </div>
    </div>    
</div>
    
@endsection
