@extends('clients.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start"> Détail du Client</div>
                <div class="float-end"><a href="{{ route('clients.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a></div>
            </div>
            <div class="card-body">

                <div class="row">
                    <label for="nom" class="col-md-4 col-form-label text-md-end text-start"><strong>Nom:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->nom }}
                    </div>
                </div>

                <div class="row">
                    <label for="email" class="col-md-4 col-form-label text-md-end text-start"><strong>Email:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->email }}
                    </div>
                </div>

                <div class="row">
                    <label for="code_client" class="col-md-4 col-form-label text-md-end text-start"><strong>Code Client:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->code_client }}
                    </div>
                </div>

                <div class="row">
                    <label for="raison_sociale" class="col-md-4 col-form-label text-md-end text-start"><strong>Raison Sociale:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->raison_sociale }}
                    </div>
                </div>

                <div class="row">
                    <label for="adresse" class="col-md-4 col-form-label text-md-end text-start"><strong>Adresse:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->adresse }}
                    </div>
                </div>

                <div class="row">
                    <label for="cp" class="col-md-4 col-form-label text-md-end text-start"><strong>Code Postal:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->cp }}
                    </div>
                </div>

                <div class="row">
                    <label for="ville" class="col-md-4 col-form-label text-md-end text-start"><strong>Ville:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->ville }}
                    </div>
                </div>

                <div class="row">
                    <label for="siret" class="col-md-4 col-form-label text-md-end text-start"><strong>Siret:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->siret }}
                    </div>
                </div>

                <div class="row">
                    <label for="telephone" class="col-md-4 col-form-label text-md-end text-start"><strong>Téléphone:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->telephone }}
                    </div>
                </div>

                <div class="row">
                    <label for="contact" class="col-md-4 col-form-label text-md-end text-start"><strong>Contact:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->contact }}
                    </div>
                </div>

                <div class="row">
                    <label for="mobile" class="col-md-4 col-form-label text-md-end text-start"><strong>Mobile:</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                        {{ $client->mobile }}
                    </div>
                </div>
                
                    <!-- Bouton de suppression -->
                    <form action="{{ route('clients.destroy', $client->id) }}" method="post" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce client?')">Supprimer</button>
                </form>
                </div>
                </div>

            </div>
        </div>

        
    </div>    
</div>

@endsection
