<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProduitSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
//        \App\Models\Produit::truncate();
  
        $csvFile = fopen(base_path("database/datas/produitssept.csv"), "r");
  
        $firstline = true;
        while (($data = fgetcsv($csvFile, 2000, ";")) !== FALSE) {
            if (!$firstline) {
                \App\Models\Produit::firstOrCreate([
                    'analytiqueA' => $data['0'],
                    'referenceA' => $data['2'],
                    'site' => '--N/A--',
                    'famille' => '--N/A--',
                    'alternatif' => $data['1']
                ]);    
            }
            $firstline = false;
        }
   
        fclose($csvFile);
        //
    }
}
