<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ClientSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
//        \App\Models\Client::truncate();

        $csvFile = fopen(base_path("database/datas/clients.csv"), "r");

        $firstline = true;
        while (($data = fgetcsv($csvFile, 2000, ";")) !== FALSE) {
            if (!$firstline) {
                \App\Models\Client::firstOrCreate([
                    'code_client' => $data['0'],
                    'raison_sociale' => $data['1'],
                    'nom' => $data['2'],
                    'email' => $data['3'],
                    'telephone' => $data['4'],
                    'adresse' => $data['5'],
                    'cp' => $data['6'],
                    'ville' => $data['7'],
                    'siret' => $data['8'],
                    'contact' => $data['9'],
                    'mobile' => $data['10']
                   
                ]);    
            }
            $firstline = false;
        }

        fclose($csvFile);
    }
}
