<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Produit;
use App\Models\Colis;


return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create('stocks', function (Blueprint $table) {
            $table->id();
            $table->date('date_mouvement')->default(DB::raw('NOW()'));
            $table->foreignIdFor(Produit::class);
            $table->foreignIdFor(Colis::class)->nullable();
            $table->integer('nombre_colis')->nullable();
            $table->string('unite');
            $table->decimal('quantite', 8, 3);
            $table->string('motif')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists('stocks');
    }
};
