<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('produits', function (Blueprint $table) {
            $table->id();
            $table->string('referenceA')->unique();
            $table->string('referenceB')->nullable();
            $table->string('site');
            $table->string('famille');
            $table->string('type')->nullable();
            $table->string('essence')->nullable();
            $table->string('qualite')->nullable();
            //$table->decimal('prix', 8, 2);
            //$table->string('unite');
            $table->string('unite')->nullable();
            $table->integer('epaisseur')->default(0);
            $table->integer('largeur')->default(0);
            $table->integer('longueur')->default(0);
            $table->integer('humidite')->default(0);
            $table->string('origine')->default('Interne');
            $table->string('alternatif')->nullable();
            $table->string('analytiqueA')->nullable();
            $table->string('analytiqueB')->nullable();
            $table->string('analytiqueC')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists('produits');
    }
};
