<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class Tarif extends Model {
    use HasFactory;

    protected $fillable = [
        'date_debut', 'date_fin','produit_id', 'prix_revient', 'pric_negociant'
    ];

    public function produit(): BelongsTo {
        return $this->belongsTo(Produit::class);
    }
    protected $casts = [
        'date_debut' => 'datetime',
        'date_fin' => 'datetime'        
    ];
}
