<?php

namespace App\Models;

use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Categorie;


class Produit extends Model {
	use HasFactory, Sortable;

	public static $unitesDeVentes = [
		'm2' 		=> ['code' => 'm2', 	'html' => 'm<sup>2</sup>'],
		'm3' 		=> ['code' => 'm3', 	'html' => 'm<sup>3</sup>'],
		'Stère' 	=> ['code' => 'Stère', 	'html' => 'Stère'],
		'Pile' 		=> ['code' => 'Pile', 	'html' => 'Pile'],
		'ml' 		=> ['code' => 'ml', 	'html' => 'ml'],
		'Pièce' 	=> ['code' => 'Pièce', 	'html' => 'Pièce'],
		'Kilo' 		=> ['code' => 'Kilo', 	'html' => 'Kilo'],
		'Litre' 	=> ['code' => 'Litre', 	'html' => 'Litre'],
		'Rouleau' 	=> ['code' => 'Rouleau', 'html' => 'Rouleau'],
		'Palette' 	=> ['code' => 'Palette', 'html' => 'Palette']
	];

	protected $fillable = [
		'referenceA',
		'referenceB',
		'site',
		'famille',
		'type',
		'essence',
		'qualite',
		'unite',
		'epaisseur',
		'largeur',
		'longueur',
		'humidite',
		'origine',
		'alternatif',
		'analytiqueA',
		'analytiqueB',
		'analytiqueC'
	];

	public $sortable = [
		'referenceA',
		'site',
		'famille',
		'type',
		'essence',
		'qualite',
		'epaisseur',
		'largeur',
		'longueur',
		'humidite',
		'origine'
	];

	public function getDescriptifFull() {
		$res = '';
        $res .= $this->famille;
        $res .= ' ' . $this->type;
        if($this->essence != '--N/A--') $res .= ' ' . $this->essence;
        $res .= ' ' . $this->qualite;
        if($this->epaisseur>0) $res .= ' ' . $this->epaisseur . 'mm';
        if($this->largeur >0) $res .= 'X' . $this->largeur . 'mm';
        if($this->longueur >0) $res .= 'X' . $this->longueur . 'mm';
        if($this->humidite > 0) $res .= ', ' . $this->humiditeLabel();
        $res .= ' (' . $this->origine . ', ' .$this->site . ')';
        return $res;
    }
	
	public function getDescriptifFullOrAlter() {
		if($this->alternatif == '') return $this->getDescriptifFull();
		else return $this->alternatif;
    }

	public function humiditeLabel() {
		return Produit::humiditeLabelStat($this->humidite);
	}

	public static function humiditeLabelStat($val) {
		if($val == 0) return '';
		if($val == 12) return 'Sec';
		if($val == 50) return 'Ressuyé';
		if($val == 100) return 'Vert';
		return $val;
	}

	public function getUniteVente(){
		return Produit::getUniteVenteStat($this->unite);
	}
	public static function getUniteVenteStat($val){
		if(isset($val) && $val != '') return Produit::$unitesDeVentes[$val]['html'];
		else return '';
	}


}
