<?php

namespace App\Models;

use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Inventaire extends Model {
    use HasFactory, Sortable;
    /**
     * Get the Produit associated with the Inventaire.
     * 
     */
    /*public function produit(): HasOne  {
        return $this->hasOne(Produit::class);
    }*/

    /**
     * Get the Produit that owns the Inventaire.
     */
    public function produit(): BelongsTo {
        return $this->belongsTo(Produit::class);
    }
    public function getUniteVente(){
		return Produit::getUniteVenteStat($this->unite);
	}
    protected $fillable = ['produit_id', 'unite', 'quantite', 'date', 'localisation'];
    protected $sortable = ['produit', 'unite', 'quantite'];
    protected $casts = [
        'date' => 'datetime'
    ];
}
