<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCommandeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array {
        return [
            'date_commande' => 'nullable|date', 
            'client_id' => 'exists:App\Models\Client,id', 
            'produit_id' => 'exists:App\Models\Produit,id', 
            'quantite' => 'integer', 
            'unite' => 'string', 
            'date_annonce' => 'nullable|date',
            'statut' => 'string',
            'observations' => 'nullable|string'];
    }
}
