<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center mt-3">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <div class="float-start">
                        Expéditions du
                        <?php if(!empty($date)): ?>
                            <?php echo e(strftime('%A %e %B %Y', strtotime($date))); ?>

                        <?php endif; ?>
                    </div>
                    <div class="float-end">
                        <a href="<?php echo e(route('gestions.index')); ?>" class="btn btn-info btn-sm">&larr; Retour</a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if($gestions->isEmpty()): ?>
                        <p>Aucune expéditions enregistrée pour ce jour.</p>
                    <?php else: ?>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">Produit</th>
                                    <th scope="col">Quantité</th>
                                    <th scope="col">Motif</th>
                                    <th scope="col">Client</th> <!-- Colonne vide pour le bouton -->
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $gestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gestion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($gestion->produit->getDescriptifFullOrAlter()); ?></td>
                                        <td class="text-center"><?php echo e($gestion->quantite * 1); ?> <?php echo e($gestion->unite); ?></td>
                                        <td><?php echo e($gestion->motif); ?></td>
                                        <td><?php echo e($gestion->client); ?></td>
                                        <td>
                                            <form action="<?php echo e(route('gestions.destroy', $gestion->id)); ?>" method="post" id="deleteForm_<?php echo e($gestion->id); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce produit en stock ?')">
                                                    <i class="bi bi-trash"></i> 
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
                <form action="<?php echo e(route('gestions.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="date" value="<?php echo e($date); ?>">
                    <!-- Ajoutez d'autres champs du formulaire ici -->

                    <div class="mb-3 row">
                        <label for="famille" class="col-md-4 col-form-label text-md-end text-start">La Famille</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['famille'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="famille"
                                id="famille">
                                <?php $__currentLoopData = $familles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $famille): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($famille); ?>" <?php if(old('famille') == $famille): ?> selected <?php endif; ?>>
                                        <?php echo e($famille); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['famille'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                   
                    <div class="mb-3 row">
                        <label for="produit_id" class="col-md-4 col-form-label text-md-end text-start">Le Produit</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['produit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="produit_id" id="produit_id" data-familles="<?php echo e(json_encode($familles)); ?>" data-produits="<?php echo e(json_encode($produits)); ?>">
                                <?php $__currentLoopData = $produits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option data-famille="<?php echo e($produit->famille); ?>" value="<?php echo e($produit->id); ?>" <?php if(old('produit_id') == $produit->id): ?> selected <?php endif; ?>>
                                        <?php echo e($produit->referenceA . ' - ' . $produit->getDescriptifFullOrAlter()); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['produit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="quantite" class="col-md-4 col-form-label text-md-end text-start">Quantité produite</label>
                        <div class="col-md-6">
                            <input type="text" class="form-control <?php $__errorArgs = ['quantite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="quantite" name="quantite" value="<?php echo e(old('quantite')); ?>">
                            <?php $__errorArgs = ['quantite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>


                    <div class="mb-3 row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start">Unité</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['unite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="unite" id="unite">
                                <?php $__currentLoopData = ['Palette', 'm3', 'Stère', 'Pile', 'ml', 'Pièce', 'Kilo', 'Rouleau', 'm2']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($option); ?>" <?php if(old('unite') == $option): ?> selected <?php endif; ?>><?php echo e($option); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['unite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="motif" class="col-md-4 col-form-label text-md-end text-start">Motif</label>
                        <div class="col-md-6">
                            <select class="form-control <?php $__errorArgs = ['motif'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2" name="motif" id="motif">
                                <?php $__currentLoopData = ['Vente Client', 'Transfert Castagné', 'Entrer Four', 'Autres']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($option); ?>" <?php if(old('motif') == $option): ?> selected <?php endif; ?>><?php echo e($option); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['motif'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="mb-3 row">
                        <label for="detail_client" class="col-md-4 col-form-label text-md-end text-start">Détail client</label>
                        <div class="col-md-6">
                            <input type="text" class="form-control <?php $__errorArgs = ['detail_client'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="detail_client" name="detail_client" value="<?php echo e(old('detail_client')); ?>">
                            <?php $__errorArgs = ['detail_client'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
           


            

                    <div class="mb-3 row">
                    
                        <input type="submit" class="col-md-3 offset-md-5 btn btn-info" value="Ajouter le Produit">
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function confirmDelete(gestionId) {
        console.log('Confirm delete function called with ID:', gestionId);
        var isConfirmed = confirm('Êtes-vous sûr de vouloir supprimer ce produit en stock ?');
        console.log('Confirmation status:', isConfirmed);

        if (isConfirmed) {
            // Supprimer le produit en stock
            document.getElementById('deleteForm_' + gestionId).submit();
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.btn-confirm-delete').forEach(function (button) {
            button.addEventListener('click', function () {
                var gestionId = this.getAttribute('data-gestion-id');
                confirmDelete(gestionId);
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('gestions.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/DevIntranetFontenoyBois/resources/views/gestions/edit.blade.php ENDPATH**/ ?>