@extends('stocks.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif

        <div class="card">
            <div class="card-header">Etat des stocks : vue consolidée par Références avec Prix</div>
            <div class="card-body">
                <a href="{{ route('stocks.create') }}" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter un mouvement de stock</a>

                  <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th scope="col">S#</th>
                        <th scope="col">Ref</th>
                        <th scope="col">Famille</th>
                        <th scope="col">Type</th>
                        <th scope="col">Essence</th>
                        <th scope="col">Qualité</th>
                        <th scope="col">Epaisseur</th>
                        <th scope="col">Largeur</th>
                        <th scope="col">Longueur</th>
                        <th scope="col">Humidité</th>
                        <th scope="col">Origine</th>
                        <th scope="col">Quantité</th>
                        <th scope="col">Prix de Revient</th>
                        <th scope="col">Total</th>
                      </tr>
                    </thead>
                    <tbody>
                        @forelse ($quantites as $data)
                        <tr class="@if($data->total_vendable>0) table-success @elseif($data->total_vendable<0) table-danger @else table-warning  @endif">
                            <th scope="row">{{ $loop->iteration }}</th>
                            <td>{{ $data->referenceA }}</td>
                            @if(null == $data->alternatif || '' == $data->alternatif)
                            <td>{{ $data->famille }}</td>
                            <td>{{ $data->type }}</td>
                            <td>@if( $data->essence == '--N/A--') &nbsp; @else {{ $data->essence }}@endif</td>
                            <td>{{ $data->qualite }}</td>
                            <td>@if($data->epaisseur>0) {{ $data->epaisseur }} @else &nbsp; @endif</td>
                            <td>@if($data->largeur>0) {{ $data->largeur }} @else &nbsp; @endif</td>
                            <td>@if($data->longueur>0) {{ $data->longueur }} @else &nbsp; @endif</td>
                            <td>{{ App\Models\Produit::humiditeLabelStat($data->humidite) }}</td>
                            <td>{{ $data->origine }}</td>
                            @else
                            <td colspan="9">{{ $data->alternatif }}</td>
                            @endif
                            <td style="text-align:right">@if($data->total_vendable!=0){{ $data->total_vendable * 1 }}&nbsp;<?= App\Models\Produit::getUniteVenteStat($data->unite_en_stock) ?>@endif</td>
                            <td style="text-align:right">@if($data->prix_revient){{ $data->prix_revient * 1 }}&nbsp;&euro;/<?= App\Models\Produit::getUniteVenteStat($data->unite_vente) ?>@endif</td>
                            <td style="text-align:right">@if($data->total_vendable * $data->prix_revient){{ $data->total_vendable * $data->prix_revient }}&nbsp;&euro;@endif</td>
                        </tr>
                        @empty
                            <td colspan="14">
                                <span class="text-danger">
                                    <strong>Aucun inventaire!</strong>
                                </span>
                            </td>
                        @endforelse
                    </tbody>
                  </table>

                  {{  $datas->withQueryString()->links() }}


            </div>
        </div>
    </div>    
</div>
    
@endsection
