@extends('produits.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-8">

        <div class="card">
            <div class="card-header">
                <div class="float-start"> Détail du Produit</div>
                <div class="float-end"><a href="{{ route('produits.index') }}" class="btn btn-primary btn-sm">&larr; Retour</a></div>
            </div>
            <div class="card-body">

                    @if(null != $produit->alternatif || '' != $produit->alternatif)
                    <div class="row">
                        <label for="alternatif" class="col-md-4 col-form-label text-md-end text-start"><strong>Descriptif alternatif:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->alternatif }}
                        </div>
                    </div>
                    @endif
                    
                    <div class="row">
                        <label for="referenceA" class="col-md-4 col-form-label text-md-end text-start"><strong>Référence:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->referenceA }}
                        </div>
                    </div>

                    @if($produit->referenceB)
                    <div class="row">
                        <label for="referenceB" class="col-md-4 col-form-label text-md-end text-start"><strong>Référence Bis:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->referenceB }}
                        </div>
                    </div>
                    @endif
                    @if($produit->site!='--N/A--')
                   <div class="row">
                        <label for="site" class="col-md-4 col-form-label text-md-end text-start"><strong>Site:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->site }}
                        </div>
                    </div>
                    @endif
                    @if($produit->famille!='--N/A--')
                    <div class="row">
                        <label for="famille" class="col-md-4 col-form-label text-md-end text-start"><strong>Famille:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->famille }}
                        </div>
                    </div>
                    @endif
                    @if($produit->type)
                    <div class="row">
                        <label for="type" class="col-md-4 col-form-label text-md-end text-start"><strong>Type:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->type }}
                        </div>
                    </div>
                    @endif
                    @if($produit->unite)
                    <div class="row">
                        <label for="unite" class="col-md-4 col-form-label text-md-end text-start"><strong>Unité de vente:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->unite }}
                        </div>
                    </div>
                    @endif
                    @if($produit->essence)
                    <div class="row">
                        <label for="essence" class="col-md-4 col-form-label text-md-end text-start"><strong>Essence:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->essence }}
                        </div>
                    </div>
                    @endif
                    @if($produit->epaisseur>0)
                    <div class="row">
                        <label for="epaisseur" class="col-md-4 col-form-label text-md-end text-start"><strong>Epaisseur:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->epaisseur }} mm
                        </div>
                    </div>
                    @endif
                    @if($produit->largeur>0)
                    <div class="row">
                        <label for="largeur" class="col-md-4 col-form-label text-md-end text-start"><strong>Largeur:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->largeur }} mm
                        </div>
                    </div>
                    @endif
                    @if($produit->longueur>0)
                    <div class="row">
                        <label for="longueur" class="col-md-4 col-form-label text-md-end text-start"><strong>Longueur:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->longueur }} mm
                        </div>
                    </div>
                    @endif
                    @if($produit->humiditeLabel())
                    <div class="row">
                        <label for="humidite" class="col-md-4 col-form-label text-md-end text-start"><strong>Humidite:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->humiditeLabel() }}
                        </div>
                    </div>
                    @endif
                    <div class="row">
                        <label for="origine" class="col-md-4 col-form-label text-md-end text-start"><strong>Origine:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->origine }}
                        </div>
                    </div>       
                    @if($produit->analytiqueA)
                    <div class="row">
                        <label for="analytiqueA" class="col-md-4 col-form-label text-md-end text-start"><strong>Code Famille:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->analytiqueA }}
                        </div>
                    </div>
                    @endif
                    @if($produit->analytiqueB)
                    <div class="row">
                        <label for="analytiqueB" class="col-md-4 col-form-label text-md-end text-start"><strong>Code Production:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->analytiqueB }}
                        </div>
                    </div>
                    @endif
                    @if($produit->analytiqueC)    
                    <div class="row">
                        <label for="analytiqueC" class="col-md-4 col-form-label text-md-end text-start"><strong>analytiqueC:</strong></label>
                        <div class="col-md-6" style="line-height: 35px;">
                            {{ $produit->analytiqueC }}
                        </div>
                    </div>       
                    @endif
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <div class="float-start">L'état des stocks</div>
            </div>
            <div class="card-body">
                <div class="row">
                    <label class="col-md-4 col-form-label text-md-end text-start"><strong>Stock consolidé à ce jour :</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">
                    @forelse ($quantites as $data)
                        {{ $data->total_vendable * 1 }} {{ $data->unite_en_stock }}
                    @empty
                        Pas de stock
                    @endforelse
                    </div>
                </div>

            @forelse ($inventaires as $data)
                <div class="row">
                    <label class="col-md-4 col-form-label text-md-end text-start"><strong>Inventaire au {{ $data->date->locale('fr')->format('j F Y')}} :</strong></label>
                    <div class="col-md-6" style="line-height: 35px;">{{ $data->quantite . ' ' . $data->unite }} {{ $data->localisation }}</div>
                </div>
            @empty
                <div class="row">
                    <label class="col-md-4 col-form-label text-md-end text-start"><strong>Pas d'inventaire</strong></label>
                    <div class="col-md-6" style="line-height: 35px;"></div>
                </div>
            @endforelse
            </div>
        </div>
    </div>    
</div>
    
@endsection
