@extends('produits.layouts')

@section('content')

<div class="row justify-content-center mt-3">
    <div class="col-md-12">

        @if ($message = Session::get('success'))
            <div class="alert alert-success" role="alert">
                {{ $message }}
            </div>
        @endif
        <div class="card">
            <div class="card-header">Liste des Produits</div>
            <div class="card-body">
                <div id="toolbar">
                <a href="{{ route('produits.create') }}" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter un Produit</a>
                <a href="{{ route('produits.createplus') }}" class="btn btn-success btn-sm my-2"><i class="bi bi-plus-circle"></i> Ajouter un Produit et son Inventaire</a>
                </div>
                <table 
                    id="table"
                    data-toolbar="#toolbar"
                    data-toggle="table"
                    data-show-toggle="false"
                    data-show-fullscreen="true"
                    data-search="true"
                    data-show-columns="true"
                    data-pagination="true"
                    data-show-pagination-switch="true"
                    data-show-export="true"
                    data-export-data-type="all"
                    data-export-types="['csv', 'excel' , 'pdf']"
                    data-cookie="true"
                    data-cookie-id-table="produitsIndex"
                    class="table table-striped table-bordered"
                    >
                    <thead>
                      <tr>
                        <th scope="col" data-sortable="true">Ref</th>
                        <th scope="col">Ref2</th>
                        <th scope="col" data-sortable="true">Site</th>
                        <th scope="col" data-sortable="true">Famille</th>
                        <th scope="col" data-sortable="true">Type</th>
                        <th scope="col" data-sortable="true">Essence</th>
                        <th scope="col" data-sortable="true">Qualité</th>
                        <th scope="col">Epaisseur</th>
                        <th scope="col">Largeur</th>
                        <th scope="col" >Longueur</th>
                        <th scope="col">Humidité</th>
                        <th scope="col" data-sortable="true">Origine</th>
                        <th scope="col" data-force-hide="true">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                        @forelse ($produits as $produit)
                        <tr>
                            <td>{{ $produit->referenceA }}</td>
                            <td>{{ $produit->referenceB }}</td>
                            @if(null == $produit->alternatif || '' == $produit->alternatif)
                            <td>{{ $produit->site }}</td>
                            <td>{{ $produit->famille }}</td>
                            <td>{{ $produit->type }}</td>
                            <td>@if( $produit->essence == '--N/A--') &nbsp; @else {{ $produit->essence }}@endif</td>
                            <td>{{ $produit->qualite }}</td>
                            <td>@if($produit->epaisseur>0) {{ $produit->epaisseur }} @else &nbsp; @endif</td>
                            <td>@if($produit->largeur>0) {{ $produit->largeur }} @else &nbsp; @endif</td>
                            <td>@if($produit->longueur>0) {{ $produit->longueur }} @else &nbsp; @endif</td>
                            <td>{{ $produit->humiditeLabel() }}</td>
                            <td>{{ $produit->origine }}</td>
                            @else
                            <td colspan="10">{{ $produit->alternatif }}</td>
                            @endif
                            <td>
                                <form action="{{ route('produits.destroy', $produit->id) }}" method="post">
                                    @csrf
                                    @method('DELETE')
                                    <a href="{{ route('produits.show', $produit->id) }}" class="btn btn-warning btn-sm"><i class="bi bi-eye"></i> Détail</a>
                                    <a href="{{ route('produits.edit', $produit->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif</a>
                                    <a href="{{ route('produits.editplus', $produit->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Modif ++</a>
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Voulez-vous vraiment supprimer ce Produit ?');"><i class="bi bi-trash"></i> Suppr</button>
                                </form>
                            </td>
                        </tr>
                        @empty
                            <td colspan="13">
                                <span class="text-danger">
                                    <strong>Aucun produit!</strong>
                                </span>
                            </td>
                        @endforelse
                    </tbody>
                  </table>
            </div>
        </div>
    </div>    
</div>
@endsection
